## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(comment = '.')
has_arrow <- requireNamespace("arrow")

## ---- results = "hide", message = FALSE, warning = FALSE----------------------
library(dplyr)
library(mrgsim.parallel)

## -----------------------------------------------------------------------------
x <- new_stream(10)

## -----------------------------------------------------------------------------
length(x)

## -----------------------------------------------------------------------------
x[[5]]

## -----------------------------------------------------------------------------
mod <- house(rtol = 1e-4, outvars = "DV")

data <- expand.ev(amt = 100, ID = 10)

## -----------------------------------------------------------------------------
out <- lapply(x, function(fs) {
  mrgsim(mod, data) %>% mutate(i = fs$i)
}) %>% bind_rows()

## ---- eval = FALSE------------------------------------------------------------
#  out <- lapply(1:10, function(i) {
#    mrgsim(mod, data) %>% mutate(i = i)
#  }) %>% bind_rows()

## -----------------------------------------------------------------------------
locker <- file.path(tempdir(), "replicate1")

x <- new_stream(10, locker = locker, format = "fst")

## -----------------------------------------------------------------------------
x[[5]]

## -----------------------------------------------------------------------------
dir.exists(dirname(x[[5]]$file))

## -----------------------------------------------------------------------------
class(x[[5]])

## -----------------------------------------------------------------------------
basename(x[[5]]$file)

## -----------------------------------------------------------------------------
out <- lapply(x, function(fs) {
  ans <- mrgsim(mod, data) %>% mutate(i = fs$i)
  write_stream(fs, ans)
  return(fs$file)
})

## -----------------------------------------------------------------------------
out[1:3]

## ---- results = "hide", message = FALSE, warning = FALSE----------------------
library(fst)
sims <- lapply(out, read_fst) 
head(sims[[8]])

## -----------------------------------------------------------------------------
sims <- internalize_fst(locker)
str(sims)

## -----------------------------------------------------------------------------
head_fst(locker, n = 8)

## -----------------------------------------------------------------------------
fst <- list_fst(locker)
fst[2]

## -----------------------------------------------------------------------------
sims <- list_fst(locker)[1:5] %>% lapply(read_fst) %>% bind_rows()

## ---- eval = has_arrow--------------------------------------------------------
x <- new_stream(10, format = "feather", locker = locker)

## ---- eval = has_arrow--------------------------------------------------------
basename(x[[5]]$file)
class(x[[5]])

## ---- eval = has_arrow--------------------------------------------------------
out <- lapply(x, function(fs) {
  ans <- mrgsim(mod, data) %>% mutate(i = fs$i)
  write_stream(fs, ans)
  return(fs$file)
})

## ---- eval = has_arrow, results = "hide", message = FALSE, warning = FALSE----
library(arrow)

ds <- arrow::open_dataset(locker, format = "feather")

## ---- eval = has_arrow--------------------------------------------------------
head(ds)

## ---- eval = has_arrow--------------------------------------------------------
sims <- filter(ds, time > 12, i < 5) %>% as_tibble()

## ---- eval = has_arrow--------------------------------------------------------
head(sims)
dim(sims)

## -----------------------------------------------------------------------------
x <- new_stream(10)

## -----------------------------------------------------------------------------
x <- format_stream(x, "fst")

## -----------------------------------------------------------------------------
x[[3]]$file
class(x[[3]])

## -----------------------------------------------------------------------------
x <- locate_stream(x, locker)
x[[2]]$file

## -----------------------------------------------------------------------------
x <- ext_stream(x, "")
x[[4]]$file

## -----------------------------------------------------------------------------
x <- new_stream(100)

## -----------------------------------------------------------------------------
x <- new_stream(seq(1, 100, 4))
x[[2]]

## -----------------------------------------------------------------------------
data <- expand.ev(amt = 100, ID = seq(10))
head(data)

## -----------------------------------------------------------------------------
chunked <- chunk_by_row(data, nchunk = 5)

## -----------------------------------------------------------------------------
x <- new_stream(chunked)

length(x)

x[[3]]

## -----------------------------------------------------------------------------
x <- new_stream(3, locker = locker)
list.files(locker, all.files = TRUE)

## -----------------------------------------------------------------------------
y <- version_locker(locker, version = "v000")

## -----------------------------------------------------------------------------
basename(locker)

## -----------------------------------------------------------------------------
basename(y)

## ---- eval = FALSE------------------------------------------------------------
#  x <- new_stream(100, locker = "existing/locker-v2")

## ---- include = FALSE---------------------------------------------------------
unlink(locker, recursive = TRUE)

## -----------------------------------------------------------------------------
x <- new_stream(5, locker = locker)
x <- new_stream(5, locker = locker)
x <- new_stream(5, locker = locker)
noreset_locker(locker)
cat("foo", file = file.path(locker, 'foo.txt'))
try(new_stream(5, locker = locker))
list.files(locker)

## ---- include = FALSE---------------------------------------------------------
if(dir.exists(locker)) unlink(locker, recursive = TRUE)

## -----------------------------------------------------------------------------
x <- new_stream(5, locker = locker)
noreset_locker(locker)

