% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par_parallel.R
\name{parallel_mrgsim_ei}
\alias{parallel_mrgsim_ei}
\alias{future_mrgsim_ei}
\alias{fu_mrgsim_ei}
\alias{fu_mrgsim_ei0}
\alias{mc_mrgsim_ei}
\title{Simulate an idata set in parallel}
\usage{
future_mrgsim_ei(
  mod,
  events,
  idata,
  nchunk = 4,
  ...,
  .as_list = FALSE,
  .p = NULL,
  .dry = FALSE,
  .seed = TRUE,
  .parallel = TRUE
)

fu_mrgsim_ei(
  mod,
  events,
  idata,
  nchunk = 4,
  ...,
  .as_list = FALSE,
  .p = NULL,
  .dry = FALSE,
  .seed = TRUE,
  .parallel = TRUE
)

fu_mrgsim_ei0(..., .dry = TRUE)

mc_mrgsim_ei(
  mod,
  events,
  idata,
  nchunk = 4,
  ...,
  .as_list = FALSE,
  .p = NULL,
  .dry = FALSE,
  .seed = NULL,
  .parallel = TRUE
)
}
\arguments{
\item{mod}{mrgsolve model object see \link[mrgsolve:mrgmod-class]{mrgsolve::mrgmod}}

\item{events}{an event object from mrgsolve; see \link[mrgsolve:ev]{mrgsolve::ev}}

\item{idata}{an idata set of parameters, one per simulation unit (individual);
see \link[mrgsolve:idata_set]{mrgsolve::idata_set}}

\item{nchunk}{number of chunks in which to split the data set}

\item{...}{passed to \link{mrgsim_d}}

\item{.as_list}{if \code{TRUE} a list is return; otherwise (default) a data frame}

\item{.p}{post processing function executed on the worker; arguments should
be (1) the simulated output (2) the model object}

\item{.dry}{if \code{TRUE} neither the simulation nor the post processing will
be done}

\item{.seed}{passed to \link{future_lapply} as \code{future.seed}}

\item{.parallel}{if \code{FALSE}, the simulation will not be parallelized; this is
intended for debugging and testing use only}
}
\value{
A data frame or list of simulated data
}
\description{
Use \link{future_mrgsim_ei} to simulate with the \code{future} package.  Use
\link{mc_mrgsim_ei} to simulate with \code{parallel::mclapply}.
}
\examples{

mod <- mrgsolve::house()

events <- mrgsolve::ev(amt = 100)

idata <- data.frame(CL = runif(10, 0.5, 1.5))

out <- future_mrgsim_ei(mod, events, idata)

}
\seealso{
\link{future_mrgsim_ei}
}
