% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.CImapSphere.R
\name{plot.CImapSphere}
\alias{plot.CImapSphere}
\title{Plotting of simultaneous credible intervals on a sphere.}
\usage{
\method{plot}{CImapSphere}(x, lon, lat, color = c("firebrick1",
  "gainsboro", "dodgerblue3"), turnOut = FALSE, title, ...)
}
\arguments{
\item{x}{List containing the simultaneous credible intervals of all
differences of smooths.}

\item{lon}{Vector containing the longitudes of the data points.}

\item{lat}{Vector containing the latitudes of the data points.}

\item{color}{Vector of length 3 containing the colors to be used in the 
credibility maps. The first color represents the credibly negative pixels, 
the second color the pixels that are not credibly different from zero
and the third color the credibly positive pixels.}

\item{turnOut}{Logical. Should the output images be turned 90 degrees 
counter-clockwise?}

\item{title}{Vector containing one string per plot. The required 
number of titles is equal to \code{length(mrbOut$ciout)}. If no \code{title} 
is passed, defaults are used.}

\item{...}{Further graphical parameters can be passed.}
}
\value{
Plots of simultaneous credible intervals for all differences of
    smooths are created.
}
\description{
Maps with simultaneous credible intervals for all differences of smooths
at neighboring scales \eqn{z_{i}} are plotted. Continental lines are added.
}
\details{
The default colors of the maps have the following meaning:
\itemize{
\item \strong{Blue}: Credibly positive pixels.
\item \strong{Red}: Credibly negative pixels.
\item \strong{Grey}: Pixels that are not credibly different from zero.
}
\code{x} corresponds to the \code{ciout}-part of the
    output of \code{\link{mrbsizeRsphere}}.
}
\examples{
# Artificial spherical sample data
set.seed(987)
sampleData <- matrix(stats::rnorm(2000), nrow = 200)
sampleData[50:65, ] <- sampleData[50:65, ] + 5
lon <- seq(-180, 180, length.out = 20)
lat <- seq(-90, 90, length.out = 10)

# mrbsizeRsphere analysis
mrbOut <- mrbsizeRsphere(posteriorFile = sampleData, mm = 20, nn = 10, 
                         lambdaSmoother = c(0.1, 1), prob = 0.95)
                           
# Posterior mean of the differences of smooths
plot(x = mrbOut$smMean, lon = lon, lat = lat,
     color = fields::tim.colors()) 

# Credibility analysis using simultaneous credible intervals
plot(x = mrbOut$ciout, lon = lon, lat = lat)

}
