% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{mrplot}
\alias{mrplot}
\title{A function for plotting NMR spectra.}
\usage{
mrplot(
  hideMenu = FALSE,
  folders = NULL,
  dimensions = NULL,
  intensity1D = NULL,
  zoom = NULL
)
}
\arguments{
\item{hideMenu}{Do not show the menu. Defaults to FALSE}

\item{folders}{Optional vector of folder names of spectra to load. Defaults to NULL}

\item{dimensions}{Optional vector dimensions of spectra to load. Defaults to NULL}

\item{intensity1D}{Optional value of initial 1D intensity. Defaults to NULL}

\item{zoom}{Optional vector of initial zoom area. Defaults to NULL}
}
\value{
{None}
}
\description{
This function plots NMR spectra. A menu of commands is displayed to edit the
plot view and add spectra. Multiple spectra will be overlaid, and if both
1D and 2D spectra are selected, they are shown in two plots with matched ranges.
}
\examples{
resetEnv()
mrplot(folders=c(system.file("extdata/1/12/pdata/10",package="mrbin"),
                 system.file("extdata/1/10/pdata/10",package="mrbin"),
                 system.file("extdata/2/10/pdata/10",package="mrbin"),
                 system.file("extdata/3/10/pdata/10",package="mrbin")),
       dimensions=c("2D","1D","1D","1D"),zoom=c(2.8,2.3,20,55),
       intensity1D=32,hideMenu=TRUE)
}
