% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_functions.R
\name{step_count}
\alias{step_count}
\title{Get step count}
\usage{
step_count(db, participant_id = NULL, start_date = NULL, end_date = NULL)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}

\item{participant_id}{A character string identifying a single participant. Use
\code{\link[mpathsenser]{get_participants}} to retrieve all participants from the database.
Leave empty to get data for all participants.}

\item{start_date}{Optional search window specifying date where to begin search. Must be
convertible to date using \link[base]{as.Date}. Use \link[mpathsenser]{first_date} to find the
date of the first entry for a participant.}

\item{end_date}{Optional search window specifying date where to end search. Must be convertible
to date using \link[base]{as.Date}. Use \link[mpathsenser]{last_date} to find the date of the
last entry for a participant.}
}
\value{
A tibble with the 'date', 'hour', and the number of 'steps'.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Extracts the number of steps per hour as sensed by the underlying operating system.
}
\keyword{internal}
