% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.mpInterval.R
\name{as.mpInterval}
\alias{as.mpInterval}
\title{Convert mpcross object to MPWGAIM format}
\usage{
as.mpInterval(
  object,
  type = "mpMarker",
  positions,
  homozygoteMissingProb,
  heterozygoteMissingProb,
  errorProb
)
}
\arguments{
\item{object}{The object of class \code{mpcrossMapped} to convert}

\item{type}{The type of MPWGAIM object to output. Must be \code{"mpMarker"} or \code{"mpInterval"}}

\item{positions}{In the case of \code{mpMarker} format, the positions at which the IBD probabilities should be output. Must be either \code{"all"} (all positions for which IBD probabilities are available) or \code{"marker"} (only marker positions).}

\item{homozygoteMissingProb}{Used as an input to \code{computeGenotypeProbabilitiesInternal}, if the IBD probabilities need to be calculated.}

\item{heterozygoteMissingProb}{Used as an input to \code{computeGenotypeProbabilitiesInternal}, if the IBD probabilities need to be calculated.}

\item{errorProb}{Used as an input to \code{computeGenotypeProbabilitiesInternal}, if the IBD probabilities need to be calculated.}
}
\value{
An object of class \code{mpMarker} or \code{mpInterval}, which are formats specified by package mpwgaim.
}
\description{
Convert an object of class \code{mpcrossMapped} to the format used by MPWGAIM.
}
\details{
MPWGAIM is a package for performing QTL analysis using multi-parent populations. This function outputs a data object suitable for input to MPWGAIM. The output object can be in MPWGAIMs \code{mpMarker} or \code{mpInterval} formats. See the documentation of MPWGAIM for further information.
}
