% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{movmods}
\alias{movmods}
\title{Table of movement processes.}
\format{
An object of class \code{"data.frame"},
with five rows and six variables: \code{name}, \code{name_short},
\code{tau_p}, \code{tau_v}, \code{hrange}, and \code{pars}.
}
\usage{
movmods
}
\description{
Table listing all current continuous-time movement processes used within 'ctmm'.
}
\references{
Calabrese et al. (2016) \url{doi:10.1111/2041-210X.12559}

\describe{
\item{name}{Movement process names (e.g., "Ind. Ident. Distr. (IID)")}
\item{name_short}{Abbreviated movement process names}
\item{tau_p}{A Boolean denoting whether or not the movement process includes position autocorrelation}
\item{tau_v}{A Boolean denoting whether or not the movement process includes velocity autocorrelation}
\item{hrange}{A Boolean denoting whether or not the movement process includes range residency}
\item{pars}{Character variable, to display autocorrelation parameters in HTML}
...
}
}
\keyword{datasets}
