% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movebank_get_vocabulary.R
\name{movebank_get_vocabulary}
\alias{movebank_get_vocabulary}
\title{Retrieve information from the movebank vocabulary describing the columns}
\usage{
movebank_get_vocabulary(
  labels,
  xml = "http://vocab.nerc.ac.uk/collection/MVB/current/",
  omit_deprecated = TRUE,
  return_type = c("definition", "list", "xml", "uri")
)
}
\arguments{
\item{labels}{Either a character vector with the column names to look up or a \code{move2} object from which the column
names will be extracted. If no argument is provided all movebank terms are returned}

\item{xml}{Either a connection to the movebank vocabulary xml, a path to the vocabulary file or an url where it can
be downloaded. The later is the default. By downloading the xml yourself the function will speed up and become
independent of an internet connection being available.}

\item{omit_deprecated}{If concepts are marked deprecated they are omitted from the set of possible labels.}

\item{return_type}{A character scalar identifying the desired return type, see details for more information on the
specific types.}
}
\value{
A named list of the selected \code{return_type}, note that if deprecated are not omitted duplicated names can
occur.
}
\description{
Retrieve information describing the columns from the 'Movebank Attribute Dictionary'
}
\details{
This function can return data in several formats (see \code{return_type} argument):
\itemize{
\item \code{definition} A named text vector with the description of the term.
\item \code{list} A list with all information for each term.
\item \code{xml} A xml_node with the definition.
\item \code{uri} A link to the full definitions page.
}
}
\examples{
\donttest{
## the names of all terms used in movebank
movebank_get_vocabulary() |>
  names()
## retrieve one variable
movebank_get_vocabulary("gps hdop")
## Count the units used in movebank
movebank_get_vocabulary() |>
  unlist() |>
  grep(pattern = "Units:", value = TRUE) |>
  sub(replacement = "", pattern = ".*Units: ") |>
  sub(replacement = "", pattern = "; .*") |>
  table() |>
  sort()
## different return types:
movebank_get_vocabulary("light-level", return_type = "definition")
movebank_get_vocabulary("light-level", return_type = "xml")
movebank_get_vocabulary("light-level", return_type = "uri")
movebank_get_vocabulary("light-level", return_type = "list")
## get definitions of all column names of a move2 object, the conversion
## to a list is for better printing
data <- mt_read(mt_example())
movebank_get_vocabulary(data) |>
  as.list()
}
}
