% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_time.R
\name{mt_time}
\alias{mt_time}
\alias{mt_time<-}
\alias{mt_set_time}
\alias{mt_time_lags}
\title{Retrieve/replace timestamps or get the interval duration between locations}
\usage{
mt_time(x)

mt_time(x) <- value

mt_set_time(x, value)

mt_time_lags(x)
}
\arguments{
\item{x}{a \code{move2} object}

\item{value}{either the new time values or the name of the new time column as a scalar character.
When the column is present then that column is used, otherwise the existing time column is renamed}
}
\value{
\code{mt_time()} returns a vector of timestamps, depending on the type of data these can be either \code{POSIXct},
\code{date}or \code{numeric} \cr
\code{mt_time_lags()} returns a vector of the time lags as \code{numeric} or \code{\link[units]{units}} depending on the type of data.
}
\description{
\itemize{
\item \code{mt_time()} retrieve timestamps
\item \code{mt_time(x) <- value} and \code{mt_set_time(x, value)}  replace timestamps with new values
\item \code{mt_time_lags()} returns time lags, i.e. duration interval between consecutive locations
}
}
\details{
Time lags are calculated as the time difference to the next location.

When calculating time lags between locations \code{NA} values are used for the transitions between tracks. This is
because the interval between the last location of the previous track and first of the next track do not make
sense.
}
\examples{
## in the simulated track, time is numeric, so the timelags are also numeric
x <- mt_sim_brownian_motion(1:3)
x |> mt_time()
x |> mt_time_lags()
## here the simulated track has timestamps, so the timelags have units
x <- mt_sim_brownian_motion(as.POSIXct((1:3) * 60^2, origin = "1970-1-1"), tracks = 1)
x |> mt_time()
x |> mt_time_lags()
x <- mt_sim_brownian_motion(as.Date(1:3, "1990-1-1"), tracks = 2)
x |> mt_time()
x |> mt_time_lags()
## units of the timelags can also be transformed, e.g. from days to hours
tl <- x |> mt_time_lags()
units::set_units(tl, h)
}
\seealso{
Other track-measures: 
\code{\link{mt_azimuth}()},
\code{\link{mt_distance}()}
}
\concept{track-measures}
