% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_read.R
\name{mt_read}
\alias{mt_read}
\title{Reading files downloaded from movebank}
\usage{
mt_read(file, ...)
}
\arguments{
\item{file}{The file path to read or a R connection (for details see \code{\link[base]{connections}})}

\item{...}{Arguments passed on to \code{\link[vroom]{vroom}}, for example \code{col_select}}
}
\value{
An object of the class \code{move2}
}
\description{
Reading files downloaded from movebank
}
\details{
Files can be \code{gz} compressed and if the same columns are present multiple files can be read simultaneously.
Using the pipe command in R and some command line tools it is possible to select specific days or months.

When using the \code{col_select} argument of \code{\link[vroom]{vroom}} it is possible to speed up file reading
considerably while reducing memory consumption.
Especially columns containing acceleration values can become quite large.

For files that contain both a \code{individual-local-identifier} and a \code{tag-local-identifier} column a
check is preformed if individuals have been wearing multiple tags over time. If this is the case tracks are
created based on the combination of both id's. A new column names \code{individual-tag-local-identifier} in created,
which will correspond to the track ids. This somewhat resembles the movebank logic however the track ids do
not necessarily correspond to the deployments in movebank as this information is not contained in exported csv's.
}
\examples{
path_fishers <- mt_example()
mt_read(path_fishers)
## Reduce the mount of data read this might provide memory advantages
## and speed up reading
mt_read(path_fishers, col_select = c(
  "location-long", "location-lat",
  "timestamp", "individual-local-identifier"
))
\dontrun{
mt_read("~/Downloads/Galapagos Albatrosses.csv")
## Exclude the column 'eobs:accelerations-raw'
mt_read("~/Downloads/Galapagos Albatrosses.csv",
  col_select = (!`eobs:accelerations-raw`)
)
## Only read records from July 2008 using a system pipe where the data
## is already filtered before reading into R
mt_read(pipe('cat "~/Downloads/Galapagos Albatrosses.csv" | grep "2008-07\\\\|time"'))
}
}
\seealso{
\itemize{
\item \code{\link[=mt_example]{mt_example()}} for the path to an example file.
}
}
