% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{mt_add_trajectory}
\alias{mt_add_trajectory}
\title{Add new trajectory to trajectory array.}
\usage{
mt_add_trajectory(data, use = "trajectories", save_as = use,
  xpos = NULL, ypos = NULL, xypos = NULL, id = "new")
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{save_as}{a character string specifying where the resulting trajectory
data should be stored.}

\item{xpos}{a vector of x positions. Ignored, if \code{xypos} is provided.}

\item{ypos}{a vector of y positions. Ignored, if \code{xypos} is provided.}

\item{xypos}{a matrix, the first column corresponding to the x positions, the
second to the y positions.}

\item{id}{a character string specifying the identifier of the to be added
trajectory.}
}
\value{
A mousetrap data object (see \link{mt_example}) where the new 
  trajectory has been added.
  If the trajectory array was provided directly as \code{data}, only the
  trajectory array will be returned.
}
\description{
Add a single new trajectory to trajectory array.
}
\examples{
# Add additional prototype to mt_prototypes
mt_prototypes_ext <- mt_add_trajectory(mt_prototypes,
   xpos = c(0,1,-1,1,-1), ypos = c(0,1.5,1.5,1.5,1.5), id = "dCoM3"
)

}
\author{
Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})

Felix Henninger
}
