% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-md.R
\name{list_setting}
\alias{list_setting}
\title{List Database Settings}
\usage{
list_setting(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A \link[tibble:tibble]{tibble::tibble} containing one row per setting with columns
describing the setting name, current value, description, and default value.
}
\description{
The \code{list_setting()} function provides a convenient way to inspect the
active configuration of a DuckDB or MotherDuck connection. It executes
the internal DuckDB function \code{duckdb_settings()} and returns the results
as a tidy tibble for easy viewing or filtering.
}
\details{
This function is particularly useful for debugging or auditing runtime
environments. All settings are returned as character columns, including
their names, current values, and default values.
}
\examples{
\dontrun{
# Connect to DuckDB
con <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))

# List all database settings
list_setting(con)

# Disconnect
DBI::dbDisconnect(con)
}
}
\seealso{
Other db-list: 
\code{\link{list_all_databases}()},
\code{\link{list_all_tables}()},
\code{\link{list_current_schemas}()},
\code{\link{list_current_tables}()},
\code{\link{list_extensions}()},
\code{\link{list_fns}()},
\code{\link{list_shares}()}
}
\concept{db-list}
