% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{configure_md_user_settings}
\alias{configure_md_user_settings}
\title{Configure a MotherDuck user's settings}
\usage{
configure_md_user_settings(
  user_name,
  motherduck_token = "MOTHERDUCK_TOKEN",
  token_type = "read_write",
  instance_size = "pulse",
  flock_size = 0
)
}
\arguments{
\item{user_name}{Character. The username of the MotherDuck user to configure.}

\item{motherduck_token}{Character. The admin user's MotherDuck token or environment variable name
(default: \code{"MOTHERDUCK_TOKEN"}).}

\item{token_type}{Character. The type of access token for the user; must be
\code{"read_write"} or \code{"read_scaling"} (default: \code{"read_write"}).}

\item{instance_size}{Character. The instance size for the user; must be one of
\code{"pulse"}, \code{"standard"}, \code{"jumbo"}, \code{"mega"}, \code{"giga"} (default: \code{"pulse"}).}

\item{flock_size}{Numeric. The flock size for the user; must be a whole number
between 0 and 60 (default: 0).}
}
\value{
A tibble containing the API response, including the updated settings for the user.
}
\description{
Updates a MotherDuck user's configuration settings, including token type,
instance size, and flock size. This function uses the MotherDuck REST API
to apply the changes for the specified user.
}
\details{
This function validates each parameter before making a \code{PUT} request to the
MotherDuck API. It ensures that:
\itemize{
\item \code{token_type} is valid using \code{validate_token_type()}.
\item \code{instance_size} is valid using \code{validate_instance_size()}.
\item \code{flock_size} is a valid integer using \code{validate_flock_size()}.
The API response is returned as a tibble for easy inspection.
}
}
\examples{
\dontrun{
configure_md_user_settings(
  user_name = "alice",
  motherduck_token = "MOTHERDUCK_TOKEN",
  token_type = "read_write",
  instance_size = "pulse",
  flock_size = 10
)
}

}
\seealso{
Other db-api: 
\code{\link{create_md_access_token}()},
\code{\link{create_md_user}()},
\code{\link{delete_md_access_token}()},
\code{\link{delete_md_user}()},
\code{\link{list_md_active_accounts}()},
\code{\link{list_md_user_instance}()},
\code{\link{list_md_user_tokens}()},
\code{\link{show_current_user}()}
}
\concept{db-api}
