% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplot.R
\name{mplot}
\alias{mplot}
\alias{mplot.default}
\alias{mplot.lm}
\alias{mplot.data.frame}
\alias{mplot.summary.lm}
\alias{mplot.TukeyHSD}
\title{Generic plotting}
\usage{
mplot(object, ...)

\method{mplot}{default}(object, ...)

\method{mplot}{lm}(
  object,
  which = c(1:3, 7),
  system = c("ggplot2", "lattice", "base"),
  ask = FALSE,
  multiplot = "package:gridExtra" \%in\% search(),
  par.settings = theme.mosaic(),
  level = 0.95,
  title = paste("model: ", deparse(object$call), "\\n"),
  rows = TRUE,
  id.n = 3L,
  id.size = 5,
  id.color = "red",
  id.nudge = 1,
  add.smooth = TRUE,
  smooth.color = "red",
  smooth.alpha = 0.6,
  smooth.size = 0.7,
  span = 3/4,
  ...
)

\method{mplot}{data.frame}(
  object,
  format,
  default = format,
  system = c("ggformula", "ggplot2", "lattice"),
  show = FALSE,
  data_text = rlang::expr_deparse(substitute(object)),
  title = "",
  ...
)

\method{mplot}{summary.lm}(
  object,
  system = c("ggplot2", "lattice"),
  level = 0.95,
  par.settings = trellis.par.get(),
  rows = TRUE,
  ...
)

\method{mplot}{TukeyHSD}(
  object,
  system = c("ggplot2", "lattice"),
  ylab = "",
  xlab = "difference in means",
  title = paste0(attr(object, "conf.level") * 100, "\% family-wise confidence level"),
  par.settings = trellis.par.get(),
  order = c("asis", "pval", "difference"),
  ...
)
}
\arguments{
\item{object}{an R object from which a plot will be constructed.}

\item{...}{additional arguments.  If \code{object} is an \code{lm}, subsets
of these arguments are passed to \code{gridExtra::grid.arrange} and to the
\pkg{lattice} plotting routines; in particular,
\code{nrow} and \code{ncol} can be used to control the number of rows
and columns used.}

\item{which}{a numeric vector used to select from 7 potential plots}

\item{system}{which graphics system to use (initially) for plotting (\pkg{ggplot2}
or \pkg{lattice}).  A check box will allow on the fly change of plotting system.}

\item{ask}{if TRUE, each plot will be displayed separately after the user
responds to a prompt.}

\item{multiplot}{if TRUE and \code{ask == FALSE}, all plots will be
displayed together.}

\item{par.settings}{\pkg{lattice} theme settings}

\item{level}{a confidence level}

\item{title}{title for plot}

\item{rows}{rows to show.  This may be a numeric vector,
\code{TRUE} (for all rows), or a character vector of row names.}

\item{id.n}{Number of id labels to display.}

\item{id.size}{Size of id labels.}

\item{id.color}{Color of id labels.}

\item{id.nudge}{a numeric used to increase (>1) or decrease (<1) the amount that observation labels are
nudged.  Use a negative value to nudge down instead of up.}

\item{add.smooth}{A logicial indicating whether a LOESS smooth should be added
(where this makes sense to do).
Currently ignored for lattice plots.}

\item{smooth.color, smooth.size, smooth.alpha}{Color, size, and alpha used for
LOESS curve.  Currently ignored for lattice plots.}

\item{span}{A positive number indicating the amount of smoothing.
A larger number indicates more smoothing. See \code{\link[stats:loess]{stats::loess()}} for details.
Currently ignored for lattice plots.}

\item{format, default}{default type of plot to create; one of
\code{"scatter"},
\code{"jitter"},
\code{"boxplot"},
\code{"violin"},
\code{"histogram"},
\code{"density"},
\code{"frequency polygon"},
or
\code{"map"}.
Unique prefixes suffice.}

\item{show}{a logical, if \code{TRUE}, the code will be displayed each time the plot is
changed.}

\item{data_text}{text representation of the data set.  In typical use cases, the default value should suffice.}

\item{ylab}{label for y-axis}

\item{xlab}{label for x-axis}

\item{order}{one of \code{"pval"}, \code{"diff"}, or \code{"asis"} determining the
order of the \code{pair} factor, which determines the order in which the differences
are displayed on the plot.}

\item{data}{a data frame containing the variables that might be used in the plot.}
}
\value{
Nothing.  Just for side effects.
}
\description{
Generic function plotting for R objects.  Currently plots exist for
\code{data.frame}s, \code{lm}s, (including \code{glm}s).
}
\details{
The method for models (lm and glm) is still a work in progress, but should be usable for
relatively simple models.  When the results for a logistic regression model created with
\code{\link[=glm]{glm()}} are satisfactory will depend on the format and structure of the data
used to fit the model.

Due to a bug in RStudio 1.3, the method for data frames may not display the controls
consistently.  We have found that executing this code usually fixes the problem:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(manipulate) 
manipulate(plot(A), A = slider(1, 10))
}\if{html}{\out{</div>}}
}
\examples{
lm( width ~ length * sex, data = KidsFeet) \%>\%
  mplot(which = 1:3, id.n = 5)
lm( width ~ length * sex, data = KidsFeet) \%>\%
  mplot(smooth.color = "blue", smooth.size = 1.2, smooth.alpha = 0.3, id.size = 3)
lm(width ~ length * sex, data = KidsFeet) \%>\%
  mplot(rows = 2:3, which = 7)
\dontrun{
mplot( HELPrct )
mplot( HELPrct, "histogram" )
}
lm(width ~ length * sex, data = KidsFeet) \%>\%
  summary() \%>\%
  mplot()
  
lm(width ~ length * sex, data = KidsFeet) \%>\%
  summary() \%>\%
  mplot(rows = c("sex", "length"))
  
lm(width ~ length * sex, data = KidsFeet) \%>\%
  summary() \%>\%
  mplot(rows = TRUE)
lm(age ~ substance, data = HELPrct) \%>\%
  TukeyHSD() \%>\%
  mplot()
lm(age ~ substance, data = HELPrct) \%>\%
  TukeyHSD() \%>\%
  mplot(system = "lattice")
}
