% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc.survFitTKTD.R
\name{ppc.survFitTKTD}
\alias{ppc.survFitTKTD}
\title{Posterior predictive check plot for \code{survFitTKTD} objects}
\usage{
\method{ppc}{survFitTKTD}(x, style = "ggplot", main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{survFitTKTD}}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{main}{main title for the plot}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{ppc} S3 method for the \code{survFitTKTD} class. It
plots the predicted values along with 95\% credible intervals
versus the observed values for \code{survFitTKTD} objects.
}
\details{
The black points show the observed number of survivors (pooled
replicates, on \eqn{X}-axis) against the corresponding predicted
number (\eqn{Y}-axis). Predictions come along with 95\% prediction
intervals, which are depicted in green when they contain the
observed value and in red otherwise. Samples with equal observed
value are shifted on the \eqn{X}-axis. For that reason, the
bisecting line (y = x), is represented by steps when observed
values are low. That way we ensure green intervals do intersect the
bisecting line.
}
\examples{

# (1) Load the data
data(propiconazole)

# (2) Create an object of class "survData"
dat <- survData(propiconazole)

\dontrun{
# (3) Run the survFitTKTD function with the TKTD model ('SD' only)
out <- survFitTKTD(dat)

# (4) Plot observed versus predicted values
ppc(out)
}

}
