% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapVariations.R
\name{morphomapVariations}
\alias{morphomapVariations}
\title{morphomapVariations}
\usage{
morphomapVariations(PCA, scores, PC, pal = blue2green2red(101), asp = 2)
}
\arguments{
\item{PCA}{list: list containing morphomapShape objects}

\item{scores}{list: list containing morphomapShape objects}

\item{PC}{list: list containing morphomapShape objects}

\item{pal}{list: list containing morphomapShape objects}

\item{asp}{numeric: aspect ratio of the morphometric map}
}
\value{
mapvar: matrix containing values of cortical thickness
}
\description{
Calculate cortical map variation from PCA
}
\examples{
\donttest{
data(Ex_mpShapeList)
PCA<-morphomapPCA(Ex_mpShapeList)
plot(PCA$PCscores)
barplot(PCA$Variance[,2])
morphomapVariations(PCA,min(PCA$PCscores[,1]),PCA$PCs[,1])
morphomapVariations(PCA,max(PCA$PCscores[,1]),PCA$PCs[,1])
}
}
\author{
Antonio Profico
}
