% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapRaster.R
\name{morphomapRaster}
\alias{morphomapRaster}
\title{morphomapRaster}
\usage{
morphomapRaster(cp, mp, pixel = 1, filename, save = FALSE)
}
\arguments{
\item{cp}{numeric: radius of the outline}

\item{mp}{numeric: number of points along the outline}

\item{pixel}{numeric: desired ratio pixel/mm}

\item{filename}{character: path of the file to be saved}

\item{save}{logical: if TRUE the raster image will be saved}
}
\value{
rimg raster image of the cross section
}
\description{
Convert a section in a raster image. It is useful to save cross section at the real size
}
\examples{
library(raster)
#rectangular section
extsec<-morphomapRectangle(10,6,100)
intsec<-morphomapRectangle(8,4,100)
rimg<-morphomapRaster(extsec,intsec,pixel=0.1,save=FALSE)
plot(rimg,col=gray(0:2/2))
#circular section
extsec<-morphomapCircle(10,100)
intsec<-morphomapCircle(8,100)
rimg<-morphomapRaster(extsec,intsec,pixel=0.1,save=FALSE)
plot(rimg,col=gray(0:2/2))
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
