% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapCentroid.R
\name{morphomapCentroid}
\alias{morphomapCentroid}
\title{morphomapCentroid}
\usage{
morphomapCentroid(cp, mp, delta = 0.1)
}
\arguments{
\item{cp}{matrix: coordinates of the external outline of the section}

\item{mp}{matrix: coordinates of the internal outline of the section}

\item{delta}{numeric: picture elements of adjustable side length}
}
\value{
centroid numeric vector: coordinates of the cortical area
}
\description{
Calculate the barycenter of the cortical area
}
\examples{
extsec<-morphomapCircle(10,100)
intsec<-morphomapCircle(8,100)
plot(extsec,asp=1,type="l")
points(intsec,col=2,type="l")
cent<-morphomapCentroid(extsec,intsec,delta = 0.1)  
points(cent[1],cent[2],pch=19,col=3)
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
