% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapDF.R
\name{morphomapDF}
\alias{morphomapDF}
\title{morphomapDF}
\usage{
morphomapDF(
  morphomap.thickness,
  rem.out = TRUE,
  fac.out = 0.5,
  smooth = TRUE,
  scale = TRUE,
  smooth.iter = 5,
  method = "equiangular",
  unwrap = "A"
)
}
\arguments{
\item{morphomap.thickness}{list: morphomap.Thickness object}

\item{rem.out}{logical: if TRUE the outlier will be removed}

\item{fac.out}{numeric: parameter to set the threshold in outliers detection}

\item{smooth}{logical: if TRUE the smooth algorithm is applied}

\item{scale}{logical: if TRUE the thichkness matrix is scaled from 0 to 1}

\item{smooth.iter}{numeric: number of smoothing iterations}

\item{method}{character: if set on "equiangular" the cortical thickness is meant as the distance of the segment intersecting the external and internal outline starting from the centroid of the section. If set on "closest" the cortical thickness is calculated at each point as the closest distance between external and internal outlines}

\item{unwrap}{character: starting qaudrant to unwrap the diaphysis ("A"=anterior, "L"=lateral, "P"=posterior, "M"=mesial)}
}
\value{
XYZ data.frame for morphometric map

labels character vector for x labels in the morphometric map
}
\description{
Tool to build a data.frame suitable for morphometric maps
}
\examples{
\donttest{
library(lattice)
library(colorRamps)
data(HomFem38023)
meshes<-morphomapSegm(HomFem38023, param1=4)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-380.23
rawSections<-morphomapCore(out.sur=perMesh,
                           inn.sur=endMesh,num.sect=61,mech.len = mech_length, 
                           start = 0.2,end=0.8)
shapeSections<-morphomapShape(rawSections,21,sects_vector=NULL,cent.out="CCA",delta=0.1)
femthick<-morphomapThickness(shapeSections)
dataDF<-morphomapDF(femthick)$XYZ
contourplot(dataDF[, 3] ~ dataDF[, 1] + dataDF[, 2],
            col.regions=blue2green2red(101),region=TRUE,
            colorkey=list(at=seq(0,1,length.out = 100)),
            scales = list(x = list(at = seq(0,100,length.out = 5), c("A","M","P","L","A"), 
            alternating = 1)),asp=1.5,cuts=20,xlab="femur margin",ylab="biomechanical length")

}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
