% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapAlignment.R
\name{morphomapAlignment}
\alias{morphomapAlignment}
\title{morphomapAlignment}
\usage{
morphomapAlignment(
  mesh,
  set,
  side = c("left", "right"),
  param1 = 4,
  iter1 = 2000,
  iter2 = 2000,
  iter3 = 2000,
  from1 = 180,
  to1 = 360,
  from2 = -5,
  to2 = 5,
  from3 = -5,
  to3 = 5,
  tol = 0.5
)
}
\arguments{
\item{mesh}{3D mesh: femur long bone mesh}

\item{set}{matrix: 7 landmarks acquired on the mesh (see details)}

\item{side}{character: specify if the femur bone is "left" or "right" side}

\item{param1}{numeric: parameter for spherical flipping (usually ranged between 3 and 4)}

\item{iter1}{numeric: number of iterations first alignment}

\item{iter2}{numeric: number of iterations second alignment}

\item{iter3}{numeric: number of iterations third alignment}

\item{from1}{numeric: inferior range of the allowed rotation in the first alignment}

\item{to1}{numeric: superior range of the allowed rotation in the first alignment}

\item{from2}{numeric: inferior range of the allowed rotation in the second alignment}

\item{to2}{numeric: superior range of the allowed rotation in the second alignment}

\item{from3}{numeric: inferior range of the allowed rotation in the third alignment}

\item{to3}{numeric: superior range of the allowed rotation in the third alignment}

\item{tol}{numeric: maximum allowed error in the alignment expressed in mm}
}
\value{
sur: mesh of the aligned femur bone

coo: coordinates of the landmark used in the alignment (plus two added automatically)

mech_length: mechanical length of the aligned femur bone
}
\description{
Align a femur bone following the protocol proposed by Ruff (2002)
}
\details{
The function 'morphomapAlignment' is designed to align a femur bone. I did not tested on other long bones. 
The function requires 7 anatomical landmarks samples as follow: 1-the point at the center of the diaphysis in posterior view after the less trochanter, 
2- the most posterior point on the lateral epicondyle, 3-the most posterior point on the medial epicondyle, 4- the most inferior point on the intercondilar fossa,
5- neck of the femur, 6- the most inferior point on the medial epicondyle and 7-the most inferior point on the lateral epicondyle. 
If the function in a short time does not complete the alignement, please stop the R session, check your landmark configuration or try to increase the value of the argument 'tol'.
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
