% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backgroundGrid.R
\name{backgroundGrid}
\alias{backgroundGrid}
\title{Create background coordinates from raster object}
\usage{
backgroundGrid(raster, spatial.subset = NULL)
}
\arguments{
\item{raster}{Raster object with projection (\code{?raster::projection} and \code{?crs}) 
from which to extract the the point grid (used as background coordinates for generating pseudo-absences)}

\item{spatial.subset}{Object of class extent (see \code{\link[raster]{extent}}) or a two
column data.frame (or matrix) of coordinates (xy, each row is a point).}
}
\value{
A list with a SpatialPolygons object and a matrix of the background coordinates
}
\description{
Creates the background coordinates used for defining the study area and for generating pseudo-absences.
}
\details{
If a data.frame, matrix or a list of the previous is passed to \code{spatial.subset} the bounding coordinates
are extracted to delimit the background. For example, to bound the study area to the spatial distribution of a species.
}
\examples{
## Load presences
data(Oak_phylo2)

## Load rasters
destfile <- tempfile()
data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)

projection(biostack$baseline) <- CRS("+proj=longlat +init=epsg:4326")
r <- biostack$baseline[[1]]

## Background around a set of coordinates
bg.species <- backgroundGrid(r, Oak_phylo2)
## Background of a subdomain of the study area
bg.subdomain <- backgroundGrid(r, extent(c(-10, 30, 35, 65)))
## Background of the whole study area
bg <- backgroundGrid(r)

# plot(bg$xy)
# plot(bg.subdomain$xy)
# plot(bg.species$xy$H11)
plot(bg.species$xy$H01)

}
\references{
Iturbide, M., Bedia, J., Herrera, S., del Hierro, O., Pinto, M., Gutierrez, J.M., 2015. 
A framework for species distribution modelling with improved pseudo-absence generation. Ecological 
Modelling. DOI:10.1016/j.ecolmodel.2015.05.018.
}
\author{
M. Iturbide
}
