% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUCextentFit.R
\name{AUCextentFit}
\alias{AUCextentFit}
\title{Non-linear model fitting for extracting an index of the minimum value in x that obtains a value in y above the asymptote}
\usage{
AUCextentFit(testmat, extents, diagrams = FALSE)
}
\arguments{
\item{testmat}{Matrix. Data in each row is fitted separatelly.}

\item{extents}{Vector of increasing values that is fitted to each row in \code{testmat}.}

\item{diagrams}{Logical (default is FALSE). If TRUE diagrams of the fitted models are returned.}
}
\value{
Named integer. Index of the minimum value in \code{extents} at which the data in \code{testmat}
is above the asymptote. The residual sum of squares is printed in the console and 
the index corresponding to the best nls fit is returned.
}
\description{
Given a matrix 
extracts an index of the extents at which the AUC (or other test statistic) overcomes the Vm coefficient 
obtained from the non-linear model fitting. Non-linear asymptotic functions are tested:
Michaelis-Menten, 3-parameter asymptotic exponential (exponential 3) and 2-parameter 
asymptotic exponential (exponential 2). For details about these functions, see the 
"non-linear regression" section of THE R BOOK by Michael J. Crawley.
}
\details{
This function is internally used by function \code{\link[mopa]{mopaTrain}}, to fit AUC 
scores to the background extents at which were obtained (see reference below).
}
\references{
Iturbide, M., Bedia, J., Herrera, S., del Hierro, O., Pinto, M., Gutierrez, J.M., 2015. 
A framework for species distribution modelling with improved pseudo-absence generation. Ecological 
Modelling. DOI:10.1016/j.ecolmodel.2015.05.018.
}
\author{
M. Iturbide
}
\keyword{internal}
