% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_questions_from.R
\name{define_questions_from_data_frame}
\alias{define_questions_from_data_frame}
\alias{define_questions_from_data_frame.question_category}
\title{Define questions from a data frame}
\usage{
define_questions_from_data_frame(qc, df)

\method{define_questions_from_data_frame}{question_category}(qc, df)
}
\arguments{
\item{qc}{A \code{question_category} object.}

\item{df}{A data frame.}
}
\value{
A \code{question_category}.
}
\description{
Each row in the text data frame is interpreted as a question. We only have to define
the columns that we are going to use, the rest of the columns are taken by default.
}
\details{
For answers where a vector is required, "<|>" is used as a separator of the vector
elements.
}
\examples{

file <- system.file("extdata", "questions.csv", package = "moodef")
df <- read_question_csv(file = file)

qc <-
  question_category(category = 'Initial test', adapt_images = TRUE) |>
  define_questions_from_data_frame(df)

}
\seealso{
Other question definition: 
\code{\link{define_question}()},
\code{\link{define_questions_from_csv}()},
\code{\link{define_questions_from_excel}()},
\code{\link{generate_xml}()},
\code{\link{generate_xml_file}()},
\code{\link{question_category}()}
}
\concept{question definition}
