% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_momentuHMM.R
\name{plot.momentuHMM}
\alias{plot.momentuHMM}
\title{Plot \code{momentuHMM}}
\usage{
\method{plot}{momentuHMM}(
  x,
  animals = NULL,
  covs = NULL,
  ask = TRUE,
  breaks = "Sturges",
  hist.ylim = NULL,
  sepAnimals = FALSE,
  sepStates = FALSE,
  col = NULL,
  cumul = TRUE,
  plotTracks = TRUE,
  plotCI = FALSE,
  alpha = 0.95,
  plotStationary = FALSE,
  ...
)
}
\arguments{
\item{x}{Object \code{momentuHMM}}

\item{animals}{Vector of indices or IDs of animals for which information will be plotted.
Default: \code{NULL} ; all animals are plotted.}

\item{covs}{Data frame consisting of a single row indicating the covariate values to be used in plots. 
If none are specified, the means of any covariates appearing in the model are used (unless covariate is a factor, in which case the first factor in the data is used).}

\item{ask}{If \code{TRUE}, the execution pauses between each plot.}

\item{breaks}{Histogram parameter. See \code{hist} documentation.}

\item{hist.ylim}{An optional named list of vectors specifying \code{ylim=c(ymin,ymax)} for the data stream histograms.
See \code{hist} documentation. Default: \code{NULL} ; the function sets default values for all data streams.}

\item{sepAnimals}{If \code{TRUE}, the data is split by individuals in the histograms.
Default: \code{FALSE}.}

\item{sepStates}{If \code{TRUE}, the data is split by states in the histograms.
Default: \code{FALSE}.}

\item{col}{Vector or colors for the states (one color per state).}

\item{cumul}{If TRUE, the sum of weighted densities is plotted (default).}

\item{plotTracks}{If TRUE, the Viterbi-decoded tracks are plotted (default).}

\item{plotCI}{Logical indicating whether to include confidence intervals in natural parameter plots (default: FALSE)}

\item{alpha}{Significance level of the confidence intervals (if \code{plotCI=TRUE}). Default: 0.95 (i.e. 95\% CIs).}

\item{plotStationary}{Logical indicating whether to plot the stationary state probabilities as a function of any covariates (default: FALSE). Ignored unless covariate are included in \code{formula}.}

\item{...}{Additional arguments passed to \code{\link[graphics]{plot}} and \code{\link[graphics]{hist}} functions. These can currently include \code{asp}, \code{cex}, \code{cex.axis}, \code{cex.lab}, \code{cex.legend}, \code{cex.main}, \code{legend.pos}, and \code{lwd}. See \code{\link[graphics]{par}}. \code{legend.pos} can be a single keyword from the list ``bottomright'', ``bottom'', ``bottomleft'', ``left'', ``topleft'', ``top'', ``topright'', ``right'', and ``center''. Note that \code{asp} and \code{cex} only apply to plots of animal tracks.}
}
\description{
Plot the fitted step and angle densities over histograms of the data, transition probabilities
as functions of the covariates, and maps of the animals' tracks colored by the decoded states.
}
\details{
The state-dependent densities are weighted by the frequency of each state in the most
probable state sequence (decoded with the function \code{\link{viterbi}}). For example, if the
most probable state sequence indicates that one third of observations correspond to the first
state, and two thirds to the second state, the plots of the densities in the first state are
weighted by a factor 1/3, and in the second state by a factor 2/3.

Confidence intervals for natural parameters are calculated from the working parameter point and covariance estimates
using finite-difference approximations of the first derivative for the transformation (see \code{\link[numDeriv]{grad}}).
For example, if \code{dN} is the numerical approximation of the first derivative of the transformation \code{N = exp(x_1 * B_1 + x_2 * B_2)}
for covariates (x_1, x_2) and working parameters (B_1, B_2), then 
\code{var(N)=dN \%*\% Sigma \%*\% dN}, where \code{Sigma=cov(B_1,B_2)}, and normal confidence intervals can be 
constructed as \code{N +/- qnorm(1-(1-alpha)/2) * se(N)}.
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

plot(m,ask=TRUE,animals=1,breaks=20,plotCI=TRUE)

}
