% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_miSum.R
\name{plot.miSum}
\alias{plot.miSum}
\title{Plot \code{miSum}}
\usage{
\method{plot}{miSum}(x, animals = NULL, covs = NULL, ask = TRUE,
  breaks = "Sturges", hist.ylim = NULL, sepAnimals = FALSE,
  sepStates = FALSE, col = NULL, cumul = TRUE, plotTracks = TRUE,
  plotCI = FALSE, alpha = 0.95, plotStationary = FALSE,
  plotEllipse = TRUE, ...)
}
\arguments{
\item{x}{Object \code{miSum} (as return by \code{\link{MIpool}})}

\item{animals}{Vector of indices or IDs of animals for which information will be plotted.
Default: \code{NULL} ; all animals are plotted.}

\item{covs}{Data frame consisting of a single row indicating the covariate values to be used in plots. If none are specified, the means of any covariates appearing in the model are used (unless covariate is a factor, in which case the first factor appearing in the data is used).}

\item{ask}{If \code{TRUE}, the execution pauses between each plot.}

\item{breaks}{Histogram parameter. See \code{hist} documentation.}

\item{hist.ylim}{Parameter \code{ylim} for the step length histograms.
See \code{hist} documentation. Default: \code{NULL} ; the function sets default values.}

\item{sepAnimals}{If \code{TRUE}, the data is split by individuals in the histograms.
Default: \code{FALSE}.}

\item{sepStates}{If \code{TRUE}, the data is split by states in the histograms.
Default: \code{FALSE}.}

\item{col}{Vector or colors for the states (one color per state).}

\item{cumul}{If TRUE, the sum of weighted densities is plotted (default).}

\item{plotTracks}{If TRUE, the Viterbi-decoded tracks are plotted (default).}

\item{plotCI}{Logical indicating whether to include confidence intervals in natural parameter plots (default: FALSE)}

\item{alpha}{Significance level of the confidence intervals (if \code{plotCI=TRUE}). Default: 0.95 (i.e. 95\% CIs).}

\item{plotStationary}{Logical indicating whether to plot the stationary state probabilities as a function of any covariates (default: FALSE)}

\item{plotEllipse}{Logical indicating whether to plot error ellipses around imputed location means. Default: TRUE.}

\item{...}{Additional arguments passed to \code{\link[graphics]{plot}} and \code{\link[graphics]{hist}} functions. These can currently include \code{asp}, \code{cex}, \code{cex.axis}, \code{cex.lab}, \code{cex.legend}, \code{cex.main}, \code{legend.pos}, and \code{lwd}. See \code{\link[graphics]{par}}. \code{legend.pos} can be a single keyword from the list ``bottomright'', ``bottom'', ``bottomleft'', ``left'', ``topleft'', ``top'', ``topright'', ``right'', and ``center''. Note that \code{asp} and \code{cex} only apply to plots of animal tracks.}
}
\description{
Plot the fitted step and angle densities over histograms of the data, transition probabilities
as functions of the covariates, and maps of the animals' tracks colored by the decoded states.
}
\details{
The state-dependent densities are weighted by the frequency of each state in the most
probable state sequence (decoded with the function \code{\link{viterbi}} for each imputation). For example, if the
most probable state sequence indicates that one third of observations correspond to the first
state, and two thirds to the second state, the plots of the densities in the first state are
weighted by a factor 1/3, and in the second state by a factor 2/3.
}
\examples{
\dontrun{
# Extract data from miExample
obsData <- miExample$obsData

# error ellipse model
err.model <- list(x= ~ ln.sd.x - 1, y =  ~ ln.sd.y - 1, rho =  ~ error.corr)

# Fit crawl to obsData
crwOut <- crawlWrap(obsData,theta=c(4,0),fixPar=c(1,1,NA,NA),
                    err.model=err.model)
                    
# Fit four imputations
bPar <- miExample$bPar
HMMfits <- MIfitHMM(crwOut,nSims=4,poolEstimates=FALSE,
                   nbStates=2,dist=list(step="gamma",angle="vm"),
                   Par0=bPar$Par,beta0=bPar$beta,
                   formula=~cov1+cos(cov2),
                   estAngleMean=list(angle=TRUE),
                   covNames=c("cov1","cov2"))
                   
# Pool estimates
miSum <- MIpool(HMMfits)
plot(miSum)
}
}
