# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Gamma density function
#'
#' Probability density function of the gamma distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param mu Mean
#' @param sigma Standard deviation
#'
#' @return Vector of densities
dgamma_rcpp <- function(x, mu, sigma) {
    .Call('_momentuHMM_dgamma_rcpp', PACKAGE = 'momentuHMM', x, mu, sigma)
}

#' Weibull density function
#'
#' Probability density function of the Weibull distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param shape Shape
#' @param scale Scale
#'
#' @return Vector of densities
dweibull_rcpp <- function(x, shape, scale) {
    .Call('_momentuHMM_dweibull_rcpp', PACKAGE = 'momentuHMM', x, shape, scale)
}

#' Normal density function
#'
#' Probability density function of the normal distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param mean Mean of the distribution 
#' @param sd Standard deviation of the distribution 
#'
#' @return Vector of densities
dnorm_rcpp <- function(x, mean, sd) {
    .Call('_momentuHMM_dnorm_rcpp', PACKAGE = 'momentuHMM', x, mean, sd)
}

#' Log-normal density function
#'
#' Probability density function of the log-normal distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param meanlog Mean of the distribution on the log-scale
#' @param sdlog Standard deviation of the distribution on the log-scale
#'
#' @return Vector of densities
dlnorm_rcpp <- function(x, meanlog, sdlog) {
    .Call('_momentuHMM_dlnorm_rcpp', PACKAGE = 'momentuHMM', x, meanlog, sdlog)
}

#' Exponential density function
#'
#' Probability density function of the exponential distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param rate Rate
#' @param foo Unused (for compatibility with template)
#'
#' @return Vector of densities
dexp_rcpp <- function(x, rate, foo) {
    .Call('_momentuHMM_dexp_rcpp', PACKAGE = 'momentuHMM', x, rate, foo)
}

#' Von Mises density function
#'
#' Probability density function of the Von Mises distribution, defined as a function
#' of the modified Bessel function of order 0 (written in C++)
#'
#' @param x Vector of quantiles
#' @param mu Mean
#' @param kappa Concentration
#'
#' @return Vector of densities
dvm_rcpp <- function(x, mu, kappa) {
    .Call('_momentuHMM_dvm_rcpp', PACKAGE = 'momentuHMM', x, mu, kappa)
}

#' Wrapped Cauchy density function
#'
#' Probability density function of the wrapped Cauchy distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param mu Mean
#' @param rho Concentration
#'
#' @return Vector of densities
dwrpcauchy_rcpp <- function(x, mu, rho) {
    .Call('_momentuHMM_dwrpcauchy_rcpp', PACKAGE = 'momentuHMM', x, mu, rho)
}

#' Probability density function of the beta distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param shape1 Shape1
#' @param shape2 Shape2
#'
#' @return Vector of densities
dbeta_rcpp <- function(x, shape1, shape2) {
    .Call('_momentuHMM_dbeta_rcpp', PACKAGE = 'momentuHMM', x, shape1, shape2)
}

#' Poisson density function
#'
#' Probability density function of the Poisson distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param rate Rate
#' @param foo Unused (for compatibility with template)
#'
#' @return Vector of densities
dpois_rcpp <- function(x, rate, foo) {
    .Call('_momentuHMM_dpois_rcpp', PACKAGE = 'momentuHMM', x, rate, foo)
}

#' Bernoulli density function
#'
#' Probability density function of the Bernoulli distribution (written in C++)
#'
#' @param x Vector of quantiles
#' @param prob success probability
#' @param foo Unused (for compatibility with template)
#'
#' @return Vector of densities
dbern_rcpp <- function(x, prob, foo) {
    .Call('_momentuHMM_dbern_rcpp', PACKAGE = 'momentuHMM', x, prob, foo)
}

#' Get design matrix
#'
#' Loop for creating full design matrix (X) from pseudo-design matrix (DM). Written in C++. Used in \code{getDM}.
#'
#' @param X full design matrix
#' @param covs matrix of covariates
#' @param DM pseudo design matrix
#' @param nr number of rows in design matrix
#' @param nc number of column in design matrix
#' @param cov covariate names
#' @param nbObs number of observations
#'
#' @return full design matrix (X)
getDM_rcpp <- function(X, covs, DM, nr, nc, cov, nbObs) {
    .Call('_momentuHMM_getDM_rcpp', PACKAGE = 'momentuHMM', X, covs, DM, nr, nc, cov, nbObs)
}

#' Negative log-likelihood
#'
#' Computation of the negative log-likelihood (forward algorithm - written in C++)
#'
#' @param nbStates Number of states,
#' @param covs Covariates,
#' @param data A \code{\link{momentuHMMData}} object of the observations,
#' @param dataNames Character vector containing the names of the data streams,
#' @param dist Named list indicating the probability distributions of the data streams. 
#' @param Par Named list containing the state-dependent parameters of the data streams, matrix of regression coefficients 
#' for the transition probabilities ('beta'), and initial distribution ('delta').
#' @param aInd Vector of indices of the rows at which the data switches to another animal
#' @param zeroInflation Named list of logicals indicating whether the probability distributions of the data streams are zero-inflated.
#' @param oneInflation Named list of logicals indicating whether the probability distributions of the data streams are one-inflated.
#' @param stationary \code{false} if there are covariates. If \code{true}, the initial distribution is considered
#' equal to the stationary distribution. Default: \code{false}.
#' @param knownStates Vector of values of the state process which are known prior to fitting the
#' model (if any). Default: NULL (states are not known). This should be a vector with length the number
#' of rows of 'data'; each element should either be an integer (the value of the known states) or NA if
#' the state is not known.
#' @param betaRef Indices of reference elements for t.p.m. multinomial logit link.
#' 
#' @return Negative log-likelihood
nLogLike_rcpp <- function(nbStates, covs, data, dataNames, dist, Par, aInd, zeroInflation, oneInflation, stationary, knownStates, betaRef) {
    .Call('_momentuHMM_nLogLike_rcpp', PACKAGE = 'momentuHMM', nbStates, covs, data, dataNames, dist, Par, aInd, zeroInflation, oneInflation, stationary, knownStates, betaRef)
}

#' Transition probability matrix
#'
#' Computation of the transition probability matrix, as a function of the covariates and the regression
#' parameters. Written in C++. Used in \code{\link{viterbi}}.
#'
#' @param nbStates Number of states
#' @param beta Matrix of regression parameters
#' @param covs Matrix of covariate values
#' @param betaRef Indices of reference elements for t.p.m. multinomial logit link.
#'
#' @return Three dimensional array \code{trMat}, such that \code{trMat[,,t]} is the transition matrix at
#' time t.
trMatrix_rcpp <- function(nbStates, beta, covs, betaRef) {
    .Call('_momentuHMM_trMatrix_rcpp', PACKAGE = 'momentuHMM', nbStates, beta, covs, betaRef)
}

#' Get XB
#'
#' Loop for computation of design matrix (X) times the working scale parameters (B). Written in C++. Used in \code{\link{w2n}}.
#'
#' @param DM design matrix
#' @param Xvec working parameters
#' @param nbObs number of observations
#' @param nr number of rows in design matrix
#' @param nc number of column in design matrix
#' @param circularAngleMean indicator for whether or not circular-circular regression model
#' @param consensus indicator for whether or not circular-circular regression consensus model
#' @param rindex row index for design matrix
#' @param cindex column index for design matrix
#' @param nbStates number of states
#'
#' @return XB matrix
XBloop_rcpp <- function(DM, Xvec, nbObs, nr, nc, circularAngleMean, consensus, rindex, cindex, nbStates) {
    .Call('_momentuHMM_XBloop_rcpp', PACKAGE = 'momentuHMM', DM, Xvec, nbObs, nr, nc, circularAngleMean, consensus, rindex, cindex, nbStates)
}

