% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIpool.R
\name{MIpool}
\alias{MIpool}
\title{Calculate pooled parameter estimates and states across multiple imputations}
\usage{
MIpool(HMMfits, alpha = 0.95, ncores, covs = NULL)
}
\arguments{
\item{HMMfits}{List comprised of \code{\link{momentuHMM}} objects}

\item{alpha}{Significance level for calculating confidence intervals of pooled estimates (including location error ellipses). Default: 0.95.}

\item{ncores}{Number of cores to use for parallel processing.}

\item{covs}{Data frame consisting of a single row indicating the covariate values to be used in the calculation of pooled natural parameters. 
For any covariates that are not specified using \code{covs}, the means of the covariate(s) across the imputations are used 
(unless the covariate is a factor, in which case the first factor in the data is used). By default, no covariates are specified.}
}
\value{
A \code{\link{miSum}} object, i.e., a list comprised of model and pooled parameter summaries, including \code{data} (averaged across imputations), \code{conditions}, \code{Par}, and \code{MIcombine} 
(as returned by \code{\link[mitools]{MIcombine}} for working parameters).

\code{miSum$Par} is a list comprised of:
\item{beta}{Pooled estimates for the working parameters}
\item{real}{Estimates for the natural parameters based on pooled working parameters and covariate means (or \code{covs}) across imputations (if applicable)}
\item{timeInStates}{The proportion of time steps assigned to each state}
\item{states}{The most freqent state assignment for each time step based on the \code{\link{viterbi}} algorithm for each model fit}
\item{stateProbs}{Pooled state probability estimates for each time step}
}
\description{
Calculate pooled parameter estimates and states across multiple imputations
}
\details{
Pooled estimates, standard errors, and confidence intervals are calculated using standard multiple imputation formulas. Working scale parameters are pooled
using \code{\link[mitools]{MIcombine}} and t-distributed confidence intervals. Natural scale parameters and normally-distributed confidence intervals are calculated by transforming the pooled working scale parameters 
and, if applicable, are based on covariate means across all imputations (and/or values specified in \code{covs}).

Note that pooled estimates for \code{timeInStates} and \code{stateProbs} do not include within-model uncertainty and are based entirely on across-model variability.
}
\examples{
\dontrun{
# Extract data and crawl inputs from miExample
obsData <- miExample$obsData
inits <- miExample$inits
err.model <- miExample$err.model

# Fit crawl to obsData
crwOut <- crawlWrap(obsData,ncores=1,theta=c(4,0),fixPar=c(1,1,NA,NA),
                    initial.state=inits,err.model=err.model)
                    
# Fit four imputations
bPar <- miExample$bPar
HMMfits <- MIfitHMM(crwOut,nSims=4,ncores=1,poolEstimates=FALSE,
                   nbStates=2,dist=list(step="gamma",angle="vm"),
                   Par0=bPar$Par,beta0=bPar$beta,delta0=bPar$delta,
                   formula=~cov1+cos(cov2),
                   estAngleMean=list(angle=TRUE),
                   covNames=c("cov1","cov2"))
                   
# Pool estimates
miSum <- MIpool(HMMfits,ncores=1)
print(miSum)
}
}
