% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{suggest_transformation}
\alias{suggest_transformation}
\title{Plot Skewness and Kurtosis and suggest transformations}
\usage{
suggest_transformation(x)
}
\arguments{
\item{x}{A dataframe of input variables.}
}
\value{
Four plots depicting skew and kurtosis of each variable. The four
plots are (1) the original, untransformed data, (2) transformed data
applying Box-Cox (tagged "tf1"), (3) tranformed data applying Yeo-Johnson
(tagged applying "tf2"), and (4) transformed data using Principal
Components (tagged "tf3"). Additionally, the three transformed data sets
generated and ready to be called with other functions using the tags.
}
\description{
\code{suggest_transformation} Evaluate the normality of the data by
calculating skew and kurtosis. The user is provided guidance regarding
whether data tranformation is advised, and how well each of three
tranformation options (Box-Cox, Yeo-Johnson, or PCA) does in reducing
non-normality as compared to each other and the original, untransformed
data set.
}
\examples{
\dontrun{
library(mlbench)
data(PimaIndiansDiabetes)
index <- sample(seq_len(nrow(PimaIndiansDiabetes)), 500)
trainingSet <- PimaIndiansDiabetes[index, ]
testSet <- PimaIndiansDiabetes[-index, ]
x <- trainingSet[, -9]
y <- trainingSet[, 9]
x_test <- testSet[, -9]
y_test <- testSet[, 9]
suggest_transformation(x)

# vignette("modeval") #check a vignette for further details
}
}
