#' Teaching evaluations at the UT Austin
#'
#' The data are gathered from end of semester student evaluations for a large 
#' sample of professors from the University of Texas at Austin. In addition, six 
#' students rate the professors' physical appearance. The result is a data frame 
#' where each row contains a different course and each column has information on 
#' either the course or the professor \url{https://www.openintro.org/stat/data/?data=evals}
#' 
#' @format A data frame with 463 observations on the following 13 variables.
#' \describe{
#'   \item{ID}{Identification variable used to distinguish rows.}
#'   \item{score}{Average professor evaluation score: (1) very unsatisfactory - (5) excellent.}
#'   \item{age}{Age of professor.}
#'   \item{bty_avg}{Average beauty rating of professor.}
#'   \item{gender}{Gender of professor: female, male.}
#'   \item{ethnicity}{Ethnicity of professor: not minority, minority.}
#'   \item{language}{Language of school where professor received education: English or non-English.}
#'   \item{rank}{Rank of professor: teaching, tenure track, tenured.}
#'   \item{pic_outfit}{Outfit of professor in picture: not formal, formal.}
#'   \item{pic_color}{Color of professor’s picture: color, black & white.}
#'   \item{cls_did_eval}{Number of students in class who completed evaluation.}
#'   \item{cls_students}{Total number of students in class.}
#'   \item{cls_level}{Class level: lower, upper.}
#' }
#' @source Çetinkaya-Rundel M, Morgan KL, Stangl D. 2013. Looking Good on Course Evaluations. CHANCE 26(2). \url{http://chance.amstat.org/2013/04/looking-good/}
#' @examples
#' library(dplyr)
#' glimpse(evals)
"evals"




