% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulas.R
\name{add_predictors}
\alias{add_predictors}
\title{Add predictors to a formula}
\usage{
add_predictors(f, ..., fun = "+")
}
\arguments{
\item{f}{A formula.}

\item{...}{Formulas whose right-hand sides will be merged to
\code{f}.}

\item{fun}{A function name indicating how to merge the right-hand
sides.}
}
\description{
This merges a one- or two-sided formula \code{f} with the
right-hand sides of all formulas supplied in \code{...}.
}
\examples{
f <- lhs ~ rhs
add_predictors(f, ~var1, ~var2)

# Left-hand sides are ignored:
add_predictors(f, lhs1 ~ var1, lhs2 ~ var2)

# fun can also be set to a function like "*":
add_predictors(f, ~var1, ~var2, fun = "*")
}

