% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_emmeans.R
\name{model_emmeans}
\alias{model_emmeans}
\title{Easy Creation of 'emmeans' Marginal Means Objects}
\usage{
model_emmeans(
  model,
  levels = NULL,
  fixed = NULL,
  modulate = NULL,
  transform = "response",
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{levels}{A character vector or formula specifying the names of the
predicting factors over which to estimate means or contrasts.}

\item{fixed}{A character vector indicating the names of the predictors to be
"fixed" (i.e., maintained), so that the estimation is made at these values.}

\item{modulate}{A character vector indicating the names of a numeric variable
along which the means or the contrasts will be estimated. Other arguments
from \code{\link{visualisation_matrix}}, such as \code{length} to adjust the
number of data points.}

\item{transform}{Is passed to the \code{type} argument in \code{emmeans::emmeans()}. See \href{https://CRAN.R-project.org/package=emmeans/vignettes/transformations.html}{this vignette}. Can be \code{"none"} (default for contrasts),
\code{"response"} (default for means), \code{"mu"}, \code{"unlink"},
\code{"log"}. \code{"none"} will leave the values on scale of the linear
predictors. \code{"response"} will transform them on scale of the response
variable. Thus for a logistic model, \code{"none"} will give estimations
expressed in log-odds (probabilities on logit scale) and \code{"response"}
in terms of probabilities.}

\item{...}{Other arguments passed for instance to \code{\link{visualisation_matrix}}.}
}
\value{
An \code{emmeans} object.
}
\description{
The \code{model_emmeans} function is a wrapper to facilitate the usage of \code{emmeans::emmeans()}, providing a somewhat simpler and smart API to find the variables of interest.
}
\examples{
library(modelbased)

model <- lm(Sepal.Length ~ Species + Petal.Width, data = iris)

# By default, 'levels' is set to "Species"
model_emmeans(model)

# One can estimate marginal means at several values of a 'modulate' variable
model_emmeans(model, modulate = "Petal.Width", length = 3)
}
