% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_fordistribution.R
\name{tailoffspringQ}
\alias{tailoffspringQ}
\alias{mostinfectiousP}
\title{The "20/80" rule}
\usage{
tailoffspringQ(
  P = 0.2,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D",
  n.seed = 1000
)

mostinfectiousP(
  Q = 0.8,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D",
  n.seed = 1000
)
}
\arguments{
\item{P, Q}{A scalar, or a vector of probability (i.e., ranging from 0 to 1).}

\item{epi.para}{A list (\code{list}) of pre-defined epidemiological parameters for offspring distribution, in the format of \code{list(mean = ?, disp = ?, shift = ?)},
where the three parameters accept non-negative values.
Each parameter must be a scalar.
For Delaporte distribution, the value of \code{mean} should be larger than the value of \code{shift}.}

\item{offspring.type}{A character label (\code{character}) indicating the type of distribution used to describe the offspring distribution.
It only accepts one of the following values:
\itemize{
\item{\code{"D"}}{ indicates the \emph{Delaporte} distribution, }
\item{\code{"NB"}}{ indicates the \emph{negative binomial} distribution, }
\item{\code{"G"}}{ indicates the \emph{geometric} distribution, or }
\item{\code{"P"}}{ indicates the \emph{Poisson} distribution. }
}
By default, \code{offspring.type = 'D'}.}

\item{n.seed}{A positive integer, for the number of seeds used to solve \code{P} or \code{Q} numerically.
By default, \code{n.seed = 1000}, and no need to change the default setting here unless for special reasons.}
}
\value{
Function \code{tailoffspringQ()} returns the proportion of (\code{Q}) offspring cases generated from proportion of (\code{P}) index cases, where (\code{P}) is given.

Function \code{mostinfectiousP()} returns the proportion of (\code{P}) index cases that generated proportion of (\code{Q}) offspring cases, where (\code{Q}) is given.
}
\description{
To calculate proportion of (\code{Q}) offspring cases generated from proportion of (\code{P}) the most infectious index cases with pre-defined epidemiological parameters for the offspring distribution.
}
\note{
When \code{n.seed} is large, e.g., \code{n.seed} > 100000, the functions could take minutes to complete.
As such, we do not recommend the users to change the default setting of \code{n.seed} unless for special reasons.

Each parameter in \code{epi.para = list(mean = ?, disp = ?, shift = ?)} should be a scalar, which means vector is not allowed here.
}
\examples{

\donttest{

## reproducing the results in Endo, et al. (2020) https://doi.org/10.12688/wellcomeopenres.15842.3,
## where ~80\% offspring cases were generated from ~10\% index cases
## with parameters R of ~2.5 (ranging from 2 to 3) and
## k of ~0.1 (ranging from 0.05 to 0.20) under NB distribution.
tailoffspringQ(
  P = 0.10,
  epi.para = list(mean = 2.5, disp = 0.10, shift = 0.2),
  offspring.type = "NB"
)
mostinfectiousP(
  Q = 0.80,
  epi.para = list(mean = 2.5, disp = 0.10, shift = 0.2),
  offspring.type = "NB"
)


## reproducing the results in Adam, et al. (2020) https://doi.org/10.1038/s41591-020-1092-0,
## where ~80\% offspring cases were generated from ~19\% index cases
## with parameters R of 0.58 and k of 0.43 under NB distribution.
tailoffspringQ(
  P = 0.19,
  epi.para = list(mean = 0.58, disp = 0.43, shift = 0.2),
  offspring.type = "NB"
)
mostinfectiousP(
  Q = 0.80,
  epi.para = list(mean = 0.58, disp = 0.43, shift = 0.2),
  offspring.type = "NB"
)

}

}
\references{
Lloyd-Smith JO, Schreiber SJ, Kopp PE, Getz WM. Superspreading and the effect of individual variation on disease emergence. \emph{Nature}. 2005;438(7066):355-359.
\doi{10.1038/nature04153}

Endo A, Abbott S, Kucharski AJ, Funk S. Estimating the overdispersion in COVID-19 transmission using outbreak sizes outside China. \emph{Wellcome Open Research}. 2020;5:67.
\doi{10.12688/wellcomeopenres.15842.3}

Adam DC, Wu P, Wong JY, Lau EH, Tsang TK, Cauchemez S, Leung GM, Cowling BJ. Clustering and superspreading potential of SARS-CoV-2 infections in Hong Kong. \emph{Nature Medicine}. 2020;26(11):1714-9.
\doi{10.1038/s41591-020-1092-0}

Zhao S, Chong MK, Ryu S, Guo Z, He M, Chen B, Musa SS, Wang J, Wu Y, He D, Wang MH. Characterizing superspreading potential of infectious disease: Decomposition of individual transmissibility. \emph{PLoS Computational Biology}. 2022;18(6):e1010281.
\doi{10.1371/journal.pcbi.1010281}
}
\seealso{
\code{\link[modelSSE:d_offspringdistn]{d_offspringdistn}}
}
