\name{getCTechSTM1/2u}

\alias{getCTechSTM1u}
\alias{getCTechSTM2u} 
\alias{getCTechSTM1/2u}

\title{Getting the List of Options CTechST for \code{compContourM1/2u}}

\description{
The functions \code{getCTechSTM1u} and \code{getCTechSTM2u} 
set the default list of options CTechST for computing 
all the directional (regression) quantiles by means of 
\code{\link{compContourM1u}} and \code{\link{compContourM2u}}, 
respectively.
}

\usage{
getCTechSTM1u()
getCTechSTM2u()
}

\arguments{
none
}

\details{
Fortunately, the default list of options usually 
leads to a satisfactory performance in all but very large 
problems.}

\value{
Both \code{getCTechSTM1u} and \code{getCTechSTM2u} produce 
a list with a few components whose default values are stated 
below after the equality sign.  

The components \code{OutFilePrefS} and \code{getCharST} 
are initialized in a method-specific way.  

The components \code{CubRegWiseI}, \code{ArchAllFI}, 
and \code{SkipRedI} are relevant only if \code{D2SpecI} 
is zero or if the dimension of directions/responses is 
higher than two, i.e., if the breadth-first search algorithm 
is used.  

Most of the components are generated by both functions.  
Nevertheless, the component \code{SkipRedI} is only generated 
by \code{getCTechSTM2u} and used by 
\code{\link{compContourM2u}}.  

The output components are as follows:  

\item{ReportI}{= 0; if some information (such as the progress 
               of computation) is displayed on the screen (1) 
               or not (0).  
               The display mode may slightly slow down the 
               computation, especially when the dimension of 
               responses is higher than two.  
               On the other hand, it shows the new value of the 
               quantile level (Tau) (if the input one has been 
               changed internally), the initial L2-normed 
               directional vector used (\code{U0Vec}), the 
               number of failures to find an initial solution 
               (\code{NNotFound}), the number of found initial 
               solutions not having the right number of clearly 
               nonzero coordinates (\code{NBad}), and also the 
               width of each layer of the breadth-first search 
               algorithm if it is employed.}

\item{OutSaveI}{= 0; if the detailed output is stored in 
                file(s) into the working directory (1) or 
                not (0).  The file output seems necessary only 
                for very large problems if some information 
                about individual cones has to be recorded 
                (such as all the regression quantile 
                hyperplanes used for the regression 
                quantile contour computation).}

\item{D2SpecI}{= 1; this option is relevant only for bivariate 
               directions/responses and determines if the cones 
               are visited counter-clockwise (1) or by means of 
               the breadth-first search algorithm as in the 
               general case (0).  The default option (1) leads 
               to a more precise and reliable computation than 
               the other.}

\item{BriefOutputI}{= 1; if the brief (1) or verbose (0) 
                    output is prepared by 
                    \code{\link{compContourM1/2u}}.  
                    Even the default option (1) is sufficient 
                    for almost all common applications.  
                    See also \code{\link{getCharSTM1u}} and 
                    \code{\link{getCharSTM2u}} for the 
                    description of the possible 
                    method-specific file output in both cases.}

\item{CubRegWiseI}{= 1; if the directional space is divided 
                   into orthants investigated separately (1) 
                   or not (0).  
                   On the one hand, the default option (1) 
                   splits the problem into smaller ones.  
                   On the other hand, it also generates 
                   some artificial cones with at least one 
                   facet in the orthant borders.}

\item{ArchAllFI}{= 1; if all the past cone facet 
                 identifiers (1) or only those from the last 
                 few layers (0) are stored during the computation.  
                 The default option (1) makes the computation 
                 more likely to terminate successfully than 
                 the other.  Unfortunately, it is also slower 
                 and more memory demanding.  If the dimension 
                 of responses is higher than three, then 
                 \code{ArchAllFI} = 1 is considered internally 
                 by \code{\link{compContourM1/2u}} no matter 
                 what the input \code{CTechST} actually says.}

\item{SkipRedI}{= 0; if the information should be skipped (1) 
                or stored (0) also from the cones with all 
                non-artificial facets already known (such cones 
                are redundant/irrelevant with probability one 
                if only all the quantile regression 
                hyperplanes necessary for the quantile contour 
                computation are required from 
                \code{\link{compContourM2u}}).  
                The skipping makes the output smaller but 
                maybe also slightly less reliable.  It also 
                affects the reliability of the information 
                regarding the inner points; see 
                \code{\link{compContourM2u}}.}

\item{OutFilePrefS}{= \sQuote{DQOutputM1_}/\sQuote{DQOutputM2_}; 
                    the prefix of possible output 
                    file name(s).}

\item{getCharST}{= getCharSTM1u/getCharSTM2u; the function 
                 computing some overall characteristics that 
                 can be replaced with a user-defined one.  
                 See \code{\link{getCharSTM1u}} and 
                 \code{\link{getCharSTM2u}} for the default 
                 choices.}
}

\examples{
##- a typical use of getCTechSTM1u: 
##computing all directional 0.01-quantiles of 49 random points 
##(uniformly distributed in the unit cube centered at zero) 
##after changing the default settings 
Tau  <- 0.01
XMat <- matrix(1, 49, 1)
YMat <- matrix(runif(3*49, -0.5, 0.5), 49, 3)
CTechST <- getCTechSTM1u()
CTechST$ReportI <- 1
COutST <- compContourM1u(Tau, YMat, XMat, CTechST)
}
