% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive.acc.R
\name{predictive.acc}
\alias{predictive.acc}
\title{Predictive performance across all trees}
\usage{
predictive.acc(object = "mfOutput", newdata = F, prob_cutoff = NULL,
  plot = T)
}
\arguments{
\item{object}{An object of class \code{mobforest.output}}

\item{newdata}{A logical value specifying if the performance needs to be
summarized on test data supplied as \code{new_test_data} argument to
\code{mobforest.analysis} function.}

\item{prob_cutoff}{Predicted probabilities converted into classes (Yes/No,
1/0) based on this probability threshold. Only used for producing predicted
Vs actual classes table.}

\item{plot}{A logical value specifying if the use wishes to view
performance plots}
}
\value{
A list with performance parameters 
\item{oob_r2 }{A vector of predictive accuracy
estimates (ranging between 0 and 1) measured on Out-of-bag cases for each
tree}
\item{oob_mse }{A vector of MSE for Out-of-bag data for each tree.
Valid only if the outcome is continuous.}
\item{oob_overall_r2 }{ Overall
predictive accuracy measured by combining Out-of-bag predictions across
trees.}
\item{oob_overall_mse }{ Overall MSE measured by combining
Out-of-bag predictions across trees.}
\item{general_r2 }{ A vector of
predictive accuracy (ranging between 0 and 1) measured on complete
learning data for each tree }
\item{general_mse }{ A vector of MSE
measured on complete learning data for each tree. Valid only if the outcome
is continuous. }
\item{general_overall_r2 }{ Overall predictive accuracy
measured by combining predictions across trees. }
\item{general_overall_mse }{ Overall MSE measured by combining predictions
across trees. Valid only if the outcome is continuous.}
\item{model_used }{ The node model and partition variables used for analysis}
\item{family }{ Error distribution assumptions of the model}
}
\description{
Predictive performance across all trees
}
\examples{
\dontrun{
library(mlbench)
set.seed(1111)
# Random Forest analysis of model based recursive partitioning load data
data("BostonHousing", package = "mlbench")
BostonHousing <- BostonHousing[1:90, c("rad", "tax", "crim", "medv", "lstat")]

# Recursive partitioning based on linear regression model medv ~ lstat with 3
# trees.  1 core/processor used. 
rfout <- mobforest.analysis(as.formula(medv ~ lstat), c("rad", "tax", "crim"),
    mobforest_controls = mobforest.control(ntree = 3, mtry = 2, replace = T,
        alpha = 0.05, bonferroni = T, minsplit = 25), data = BostonHousing,
    processors = 1, model = linearModel, seed = 1111)

# get predictive performance estimates and produce a performance plot
pacc <- predictive.acc(rfout)
}

}
