% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_bin.R
\name{batch_bin}
\alias{batch_bin}
\title{Apply monotonic binning to all vectors in dataframe}
\usage{
batch_bin(y, xs, method = 1)
}
\arguments{
\item{y}{A numeric vector with 0/1 binary values.}

\item{xs}{A dataframe with numeric vectors to discretize.}

\item{method}{A integer from 1 to 7 referring to implementations below:
1. Implementation of iso_bin()  2. Implementation of qtl_bin()
3. Implementation of bad_bin()  4. Implementation of rng_bin()
5. Implementation of gbm_bin()  6. Implementation of kmn_bin()
7. Implementation of arb_bin()}
}
\value{
A list of binning outcomes with 2 dataframes:
          bin_sum: A dataframe of binning summary.
          bin_out: A list of binning output from binning functions,
                   e.g. qtl_bin().
}
\description{
The function \code{batch_bin} applies multiple binning algorithms in
batch to each vector in the dataframe.
}
\examples{
data(hmeq)
batch_bin(hmeq$BAD, hmeq[, c('DEROG', 'DELINQ')])
}
