% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_joined_between.R
\name{mnis_joined_between}
\alias{mnis_joined_between}
\title{mnis_joined_between}
\usage{
mnis_joined_between(start_date = "1900-01-01", end_date = Sys.Date(),
  house = "all", party = NULL, eligible = "all", tidy = TRUE)
}
\arguments{
\item{start_date}{The start date of the search, in yyyy-mm-dd format. Defaults to '1900-01-01'.}

\item{end_date}{The end date of the search, in yyyy-mm-dd format. Defaults to the current date.}

\item{house}{The house to which the member belongs. Accepts one of 'all', 'lords' and 'commons', defaults to 'all'.}

\item{party}{The party to which a member belongs. Defaults to NULL.}

\item{eligible}{If the member is currently eligible to sit. Accepts one of 'all', 'current', 'former', defaults to 'all'.}

\item{tidy}{Fix the variable names in the tibble to remove non-alphanumeric characters and superfluous text. Defaults to FALSE.}
}
\description{
Function returns all members who took their seats in the house between two given dates. The function requests data in JSON format and parses it to a tibble. The
}
\examples{
\dontrun{
x <- mnis_joined_between(start_date = '2015-01-01', end_date ='2017-01-01',
                         house='all', party='labour', eligible='all')

}
}
\keyword{mnis}
