% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmrm-methods.R
\name{mmrm_methods}
\alias{mmrm_methods}
\alias{summary.mmrm}
\alias{print.summary.mmrm}
\alias{confint.mmrm}
\title{Methods for \code{mmrm} Objects}
\usage{
\method{summary}{mmrm}(object, ...)

\method{print}{summary.mmrm}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{confint}{mmrm}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{(\code{mmrm})\cr the fitted MMRM including Jacobian and call etc.}

\item{...}{not used.}
}
\value{
Depends on the method, see Details and Functions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
While printing the summary of (\code{mmrm})\cr object, the following will be displayed:
\enumerate{
\item Formula. The formula used in the model.
\item Data. The data used for analysis, including number of subjects, number of valid observations.
\item Covariance. The covariance structure and number of variance parameters.
\item Method. Restricted maximum likelihood(REML) or maximum likelihood(ML).
\item Model selection criteria. AIC, BIC, log likelihood and deviance.
\item Coefficients. Coefficients of the covariates.
\item Covariance estimate. The covariance estimate(for each group).
\enumerate{
\item If the covariance structure is non-spatial, the covariance matrix of all categorical time points available
in data will be displayed.
\item If the covariance structure is spatial, the covariance matrix of two time points with unit distance
will be displayed.
}
}

\code{confint} is used to obtain the confidence intervals for the coefficients.
Please note that this is different from the confidence interval of difference
of least square means from \code{emmeans}.
}
\section{Functions}{
\itemize{
\item \code{summary(mmrm)}: summarizes the MMRM fit results.

\item \code{print(summary.mmrm)}: prints the MMRM fit summary.

\item \code{confint(mmrm)}: obtain the confidence intervals for the coefficients.

}}
\examples{
formula <- FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID)
object <- mmrm(formula, fev_data)
# Summary:
summary(object)
# Confidence Interval:
confint(object)
}
\seealso{
\code{\link{mmrm_tmb_methods}}, \code{\link{mmrm_tidiers}} for additional methods.
}
\keyword{internal}
