% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwr_func_lmer.R
\name{pwr_func_lmer}
\alias{pwr_func_lmer}
\title{Power Analysis for Clustered Data}
\usage{
pwr_func_lmer(
  betas = list(int = 0, x1 = -5, x2 = 2, x3 = 10),
  dists = list(x1 = stats::rnorm, x2 = stats::rbinom, x3 = stats::rnorm),
  distpar = list(x1 = list(mean = 0, sd = 1), x2 = list(size = 1, prob = 0.4), x3 =
    list(mean = 1, sd = 2)),
  N = 25,
  reps = 1000,
  alpha = 0.05,
  var_intr = "x1",
  grp = "ID",
  mod = paste0("out ~ x1 + x2 + x3 + (1|", grp, ")"),
  catsmod = "out ~ x1 + x2 + x3",
  r_slope = "x1",
  r_int = "int",
  n_time = 20,
  mean_i = 0,
  var_i = 1,
  mean_s = 0,
  var_s = 1,
  cov_is = 0,
  mean_r = 0,
  var_r = 1,
  cor_mat = NULL,
  corvars = NULL
)
}
\arguments{
\item{betas}{Named list of true coefficient values for the fixed effects.}

\item{dists}{Named list of functions to generate random distributions for each
predictor.}

\item{distpar}{Named list of parameter lists for each distribution function in
\code{dists}.}

\item{N}{Integer specifying the number of groups.}

\item{reps}{Integer specifying the number of replications for the simulation.}

\item{alpha}{Numeric value specifying the significance level for hypothesis
testing.}

\item{var_intr}{Name of the variable of interest (for power calculations) as
a string.}

\item{grp}{Name of the grouping variable as a string.}

\item{mod}{Formula for the mixed-effects model.}

\item{catsmod}{Formula for the CATs model.}

\item{r_slope}{Name of the random slope variable as a string.}

\item{r_int}{Name of the random intercept as a string.}

\item{n_time}{Integer specifying the number of time points per group.}

\item{mean_i}{Mean for the random intercept.}

\item{var_i}{Variance for the random intercept.}

\item{mean_s}{Mean for the random slope.}

\item{var_s}{Variance for the random slope.}

\item{cov_is}{Covariance between the random intercept and slope.}

\item{mean_r}{Mean for the residual error.}

\item{var_r}{Variance for the residual error.}

\item{cor_mat}{Correlation matrix for correlated predictors, if any.}

\item{corvars}{List of vectors, each vector containing names of correlated
variables.}
}
\value{
A dataframe summarizing the results of the power analysis, including
average coefficient estimate, rejection rate, root mean square error,
relative root mean square error, coverage probability, and average
confidence interval width for each method.
}
\description{
Conducts a power analysis for clustered data using simulation. This function
allows for comparing the performance of different estimation methods in terms
of power, rejection rate, root mean square error (RMSE), relative RMSE, coverage
probability, and average confidence interval width.
}
\examples{
pwr_func_lmer(reps = 2)

}
