% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulx.R
\name{simulx}
\alias{simulx}
\title{Simulation of mixed effects models and longitudinal data}
\usage{
simulx(model = NULL, parameter = NULL, output = NULL, treatment = NULL,
  regressor = NULL, varlevel = NULL, group = NULL, data = NULL,
  project = NULL, nrep = 1, npop = NULL, fim = NULL,
  result.folder = NULL, result.file = NULL, stat.f = "statmlx",
  addlines = NULL, settings = NULL)
}
\arguments{
\item{model}{a \code{Mlxtran}, \code{R} or \code{PharmML} model used for the simulation}

\item{parameter}{a vector of parameters with their names and values}

\item{output}{a list (or list of lists) with fields: 
\itemize{
  \item \code{name}: a vector of output names
  \item \code{time}: a vector of times (only for the longitudinal outputs)
  \item \code{lloq}: lower limit of quantification (only for the longitudinal outputs)
  \item \code{uloq}: upper limit of quantification (only for the longitudinal outputs)
  \item \code{limit}: lower bound of the censoring interval (only for the longitudinal outputs)
}}

\item{treatment}{a list with fields
\itemize{
  \item \code{time} : a vector of input times,
  \item \code{amount} : a scalar or a vector of amounts,
  \item \code{rate} : a scalar or a vector of infusion rates (default=\code{Inf}),
  \item \code{tinf} : a scalar or a vector of infusion times (default=0),
  \item \code{type} : the type of input (default=1),
  \item \code{target} : the target compartment (default=NULL). 
}}

\item{regressor}{a list, or a list of lists, with fields
\itemize{
  \item \code{name} : a vector of regressor names,
  \item \code{time} : a vector of times,
  \item \code{value} : a vector of values.
}}

\item{varlevel}{(IOV supported by mlxR >= 3.2.2) a list (or a dataframe) with fields: 
\itemize{
  \item \code{name} : name of the variable which defines the occasions,
  \item \code{time} : a vector of times (beginnings of occasions) ,
}}

\item{group}{a list, or a list of lists, with fields: 
\itemize{
  \item \code{size} : size of the group (default=1),
  \item \code{level} : level(s) of randomization,
  \item \code{parameter} : if different parameters per group are defined,
  \item \code{output} : if different outputs per group are defined,
  \item \code{treatment} : if different treatements per group are defined,
  \item \code{regressor} : if different regression variables per group are defined.
}}

\item{data}{a list (output of simulx when settings$data.in==TRUE)}

\item{project}{the name of a Monolix project}

\item{nrep}{number of replicates}

\item{npop}{number of population parameters to draw randomly}

\item{fim}{a string with the Fisher Information Matrix to be used}

\item{result.folder}{the name of the folder where the outputs of simulx should be stored}

\item{result.file}{the name of the single file where the outputs of simulx should be saved}

\item{stat.f}{a R function for computing some summary (mean, quantiles, survival,...) of the simulated data. Default = "statmlx".}

\item{addlines}{a list with fields: 
\itemize{
  \item \code{section}: a string (default = "[LONGITUDINAL]"),
  \item \code{block}: a string (default = "EQUATION:"),
  \item \code{formula}: string, or vector of strings, to be inserted .
}}

\item{settings}{a list of optional settings
\itemize{
  \item \code{seed} : initialization of the random number generator (integer),
  \item \code{load.design} : TRUE/FALSE (if load.design is not defined, a test is automatically performed to check if a new design has been defined),
  \item \code{data.in} : TRUE/FALSE (default=FALSE)
  \item \code{id.out}  : add columns id (when N=1) and group (when #group=1), TRUE/FALSE (default=FALSE)
  \item \code{kw.max} : maximum number of trials for generating a positive definite covariance matrix (default = 100) 
  \item \code{sep} : the field separator character (default = ",") 
  \item \code{digits} : number of decimal digits in output files (default = 5) 
  \item \code{disp.iter} : TRUE/FALSE (default = FALSE) display replicate and population numbers
  \item \code{replacement} : TRUE/FALSE (default = FALSE) sample id's with/without replacement
  \item \code{out.trt} : TRUE/FALSE (default = TRUE) output of simulx includes treatment
}}
}
\value{
A list of data frames. Each data frame is an output of simulx
}
\description{
Compute predictions and sample data from \code{Mlxtran}, \code{R} and \code{PharmML} models
}
\details{
simulx takes advantage of the modularity of hierarchical models for simulating 
different components of a model: models for population parameters, individual 
covariates, individual parameters and longitudinal data.

Furthermore, \code{simulx} allows to draw different types of longitudinal data, 
including continuous, count, categorical, and time-to-event data.

The models are encoded using either the model coding language \samp{Mlxtran}, \samp{R} or the 
markup language \samp{PharmML}. \samp{Mlxtran} models are automatically converted into C++ codes, 
compiled on the fly and linked to R using the \samp{Rcpp} package. 
That allows one to implement very easily complex models and to take advantage 
of the numerical sovers used by the C++ \samp{mlxLibrary}.

See http://simulx.webpopix.org for more details.
}
\examples{
\dontrun{
myModel <- inlineModel("
[LONGITUDINAL]
input = {A, k, c, a}
EQUATION:
t0    = 0 
f_0   = A
ddt_f = -k*f/(c+f)
DEFINITION:
y = {distribution=normal, prediction=f, sd=a}
[INDIVIDUAL]
input = {k_pop, omega}
DEFINITION:
k = {distribution=lognormal, prediction=k_pop, sd=omega}
")
f <- list(name='f', time=seq(0, 30, by=0.1))
y <- list(name='y', time=seq(0, 30, by=2))
res <- simulx(model     = 'model/home.txt', 
              parameter = c(A=100, k_pop=6, omega=0.3, c=10, a=2), 
              output    = list(f,y,"k"),
              group     = list(size=4, level='individual'))

plot(ggplotmlx() + geom_line(data=res$f, aes(x=time, y=f, colour=id)) +
     geom_point(data=res$y, aes(x=time, y=y, colour=id)))
print(res$parameter)
}

}
