% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gcv_cov}
\alias{gcv_cov}
\title{Generalized Cross Validation}
\usage{
gcv_cov(bw, t, y, X, verbose = 1L)
}
\arguments{
\item{bw}{double, bandwidth}

\item{t}{vector, scaled time \mjseqn{[0,1]}}

\item{y}{vector, response}

\item{X}{matrix, covariates matrix}

\item{verbose}{bool, whether to print the  numerator and denominator in GCV value}
}
\value{
GCV value
}
\description{
Given a bandwidth, compute its corresponding GCV value \loadmathjax
}
\details{
Generalized cross validation value is defined as
\mjsdeqn{n^{-1}| Y-\hat{Y}|^2/[1- \mathrm{tr}(Q(b)) / n]^2}
When computing \mjseqn{\mathrm{tr}(Q(b))},
we use the fact that the first derivative of coefficient function is zero at central point
The ith diagonal value of \mjseqn{Q(b)} is actually \mjseqn{x^T(t_i)S^{-1}_{n}x(t_i)}
where \mjseqn{S^{-1}_{n}} means the top left p-dimension square matrix of
\mjseqn{S_{n}(t_i) = X^T W(t_i) X}, \mjseqn{W(t_i)} is the kernel weighted matrix. Details on
the computation of \mjseqn{S_n} could be found in \code{LocLinear} and its reference
}
\examples{
param = list(d = -0.2, heter = 2, tvd = 0,
 tw = 0.8, rate = 0.1, cur = 1, center = 0.3,
  ma_rate =  0, cov_tw =  0.2, cov_rate = 0.1,
   cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
data = Qct_reg(1000, param)
value <- gcv_cov(0.2, (1:1000)/1000, data$y, data$x)
}
