% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvCoxPH.R
\name{autoplot.LearnerSurvCoxPH}
\alias{autoplot.LearnerSurvCoxPH}
\title{Plots for Cox Proportional Hazards Learner}
\usage{
\method{autoplot}{LearnerSurvCoxPH}(object, type = "ggforest", ...)
}
\arguments{
\item{object}{(\link[mlr3proba:mlr_learners_surv.coxph]{mlr3proba::LearnerSurvCoxPH}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{...}{Additional parameters passed down to \code{ggforest}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3proba:mlr_learners_surv.coxph]{mlr3proba::LearnerSurvCoxPH}.

The argument \code{type} controls what kind of plot is drawn.
The only possible choice right now is \code{"ggforest"} (default) which is a
Forest Plot, using \link[survminer:ggforest]{ggforest}.
This plot displays the estimated hazard ratios (HRs) and their confidence
intervals (CIs) for different variables included in the (trained) model.
}
\examples{
\donttest{
if (requireNamespace("mlr3proba")) {
  library(mlr3proba)
  library(mlr3viz)

  task = tsk("lung")
  learner = lrn("surv.coxph")
  learner$train(task)
  autoplot(learner)
}
}
}
