% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{tune}
\alias{tune}
\title{Function for Tuning}
\usage{
tune(
  method,
  task,
  learner,
  resampling,
  measures,
  term_evals = NULL,
  term_time = NULL,
  search_space = NULL,
  store_models = FALSE,
  allow_hotstart = FALSE,
  ...
)
}
\arguments{
\item{method}{(\code{character(1)})\cr
Key to retrieve tuner from \link{mlr_tuners} dictionary.}

\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to tune.}

\item{resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling that is used to evaluated the performance of the hyperparameter
configurations. Uninstantiated resamplings are instantiated during
construction so that all configurations are evaluated on the same data
splits. Already instantiated resamplings are kept unchanged. Specialized
\link{Tuner} change the resampling e.g. to evaluate a hyperparameter
configuration on different data splits. This field, however, always returns
the resampling passed in construction.}

\item{measures}{(list of \link[mlr3:Measure]{mlr3::Measure})\cr
Measures to optimize.}

\item{term_evals}{(\code{integer(1)})\cr
Number of allowed evaluations.}

\item{term_time}{(\code{integer(1)})\cr
Maximum allowed time in seconds.}

\item{search_space}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Hyperparameter search space. If \code{NULL} (default), the search space is
constructed from the \link{TuneToken} of the learner's parameter set
(learner$param_set).}

\item{store_models}{(\code{logical(1)})\cr
If \code{TRUE}, fitted models are stored in the benchmark result
(\code{archive$benchmark_result}). If \code{store_benchmark_result = FALSE}, models
are only stored temporarily and not accessible after the tuning. This
combination is needed for measures that require a model.}

\item{allow_hotstart}{(\code{logical(1)})\cr
Allow to hotstart learners with previously fitted models. See also
\link[mlr3:HotstartStack]{mlr3::HotstartStack}. The learner must support hotstarting. Sets
\code{store_models = TRUE}.}

\item{...}{(named \code{list()})\cr
Named arguments to be set as parameters of the tuner.}
}
\value{
\code{TuningInstanceSingleCrit} | \code{TuningInstanceMultiCrit}
}
\description{
Function to tune a \link[mlr3:Learner]{mlr3::Learner}.
}
\examples{
learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE))

instance = tune(
  method = "random_search",
  task = tsk("pima"),
  learner = learner,
  resampling = rsmp ("holdout"),
  measures = msr("classif.ce"),
  term_evals = 4)

# apply hyperparameter values to learner
learner$param_set$values = instance$result_learner_param_vals
}
