% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazy_tensor.R
\name{lazy_tensor}
\alias{lazy_tensor}
\title{Create a lazy tensor}
\usage{
lazy_tensor(data_descriptor = NULL, ids = NULL)
}
\arguments{
\item{data_descriptor}{(\code{\link{DataDescriptor}} or \code{NULL})\cr
The data descriptor or \code{NULL} for a lazy tensor of length 0.}

\item{ids}{(\code{integer()})\cr
The elements of the \code{data_descriptor} to be included in the lazy tensor.}
}
\description{
Create a lazy tensor.
}
\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
ds = dataset("example",
  initialize = function() self$iris = iris[, -5],
  .getitem = function(i) list(x = torch_tensor(as.numeric(self$iris[i, ]))),
  .length = function() nrow(self$iris)
)()
dd = as_data_descriptor(ds, list(x = c(NA, 4L)))
lt = as_lazy_tensor(dd)
\dontshow{\}) # examplesIf}
}
