# mlr3spatiotempcv

Spatiotemporal resampling methods for mlr3.

<!-- badges: start -->

[![tic](https://github.com/mlr-org/mlr3spatiotempcv/workflows/tic/badge.svg?branch=master)](https://github.com/mlr-org/mlr3spatiotempcv/actions)
[![Coverage status](https://codecov.io/gh/mlr-org/mlr3spatiotempcv/branch/master/graph/badge.svg)](https://codecov.io/github/mlr-org/mlr3spatiotempcv?branch=master)
[![Lifecycle: maturing](https://img.shields.io/badge/lifecycle-maturing-blue.svg)](https://www.tidyverse.org/lifecycle/#maturing) 
[![CodeFactor](https://www.codefactor.io/repository/github/mlr-org/mlr3spatiotempcv/badge)](https://www.codefactor.io/repository/github/mlr-org/mlr3spatiotempcv)

<!-- badges: end -->

This package extends the [mlr3](https://github.com/mlr-org/mlr3) package framework with spatiotemporal resampling and visualization methods.

# Installation

The package is not yet on CRAN but can be installed from GitHub via

```r
remotes::install_github("mlr-org/mlr3spatiotempcv")
```

# Get Started

See the ["Get Started"](https://mlr3spatiotempcv.mlr-org.com/articles/mlr3spatiotempcv.html) vignette for a quick introduction.

For more detailed information including an usage example see the ["Spatiotemporal Analysis"](https://mlr3book.mlr-org.com/spatiotemporal.html) chapter in the mlr3book.

Article ["Spatiotemporal Visualization"](https://mlr3spatiotempcv.mlr-org.com/articles/spatiotemp-viz.html) shows how 3D subplots grids can be created.

# Citation

To cite the package in publications, use the output of `citation("mlr3spatiotempcv")`.
