% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurv.R
\name{MeasureSurv}
\alias{MeasureSurv}
\title{Survival Measure}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3:Measure]{mlr3::Measure}.}
\description{
This measure specializes \link[mlr3:Measure]{mlr3::Measure} for survival problems.
Predefined measures can be found in the \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} \link[mlr3:mlr_measures]{mlr3::mlr_measures}.
}
\section{Construction}{
\preformatted{MeasureSurv$new(id, range, minimize, aggregator = NULL,
                properties = character(), predict_type = "distr",
                task_properties = character(), packages = character())
}

For a description of the arguments, see \link[mlr3:Measure]{mlr3::Measure}.
The \code{task_type} is set to \code{"surv"}.
Possible values for \code{predict_type} are \code{"distr"}, \code{"lp"}, \code{"crank"}, and \code{"response"}.
}

\section{Fields}{

See \link{Measure}.
}

\section{Methods}{

See \link{Measure}.
}

\seealso{
Example survival measures: \code{\link[=MeasureSurvGraf]{surv.graf}},
\code{\link[=MeasureSurvHarrellC]{surv.harrellC}}.
}
\concept{Measure}
