% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphLearner.R
\name{mlr_learners_graph}
\alias{mlr_learners_graph}
\alias{GraphLearner}
\title{Encapsulate a Graph as a Learner}
\format{
\code{\link{R6Class}} object inheriting from \code{\link[mlr3:Learner]{mlr3::Learner}}.
}
\description{
A \code{\link[mlr3:Learner]{Learner}} that encapsulates a \code{\link{Graph}} to be used in
\link[mlr3:mlr3-package]{mlr3} resampling and benchmarks.

The Graph must return a single \code{\link[mlr3:Prediction]{Prediction}} on its \verb{$predict()}
call. The result of the \verb{$train()} call is discarded, only the
internal state changes during training are used.

The \code{predict_type} of a \code{\link{GraphLearner}} can be obtained or set via it's \code{predict_type} active binding.
Setting a new predict type will try to set the \code{predict_type} in all relevant
\code{\link{PipeOp}} / \code{\link[mlr3:Learner]{Learner}} encapsulated within the \code{\link{Graph}}.
Similarly, the predict_type of a Graph will always be the smallest denominator in the \code{\link{Graph}}.

A \code{GraphLearner} is always constructed in an untrained state. When the \code{graph} argument has a
non-\code{NULL} \verb{$state}, it is ignored.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{GraphLearner$new(graph, id = NULL, param_vals = list(), task_type = NULL, predict_type = NULL)
}\if{html}{\out{</div>}}
\itemize{
\item \code{graph} :: \code{\link{Graph}} | \code{\link{PipeOp}}\cr
\code{\link{Graph}} to wrap. Can be a \code{\link{PipeOp}}, which is automatically converted to a \code{\link{Graph}}.
This argument is usually cloned, unless \code{clone_graph} is \code{FALSE}; to access the \code{\link{Graph}} inside \code{GraphLearner} by-reference, use \verb{$graph}.\cr
\item \code{id} :: \code{character(1)}
Identifier of the resulting \code{\link[mlr3:Learner]{Learner}}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings . Default \code{list()}.
\item \code{task_type} :: \code{character(1)}\cr
What \code{task_type} the \code{GraphLearner} should have; usually automatically inferred for \code{\link{Graph}}s that are simple enough.
\item \code{predict_type} :: \code{character(1)}\cr
What \code{predict_type} the \code{GraphLearner} should have; usually automatically inferred for \code{\link{Graph}}s that are simple enough.
\item \code{clone_graph} :: \code{logical(1)}\cr
Whether to clone \code{graph} upon construction. Unintentionally changing \code{graph} by reference can lead to unexpected behaviour,
so \code{TRUE} (default) is recommended. In particular, note that the \verb{$state} of \verb{$graph} is set to \code{NULL} by reference on
construction of \code{GraphLearner}, during \verb{$train()}, and during \verb{$predict()} when \code{clone_graph} is \code{FALSE}.
}
}

\section{Fields}{

Fields inherited from \code{\link{PipeOp}}, as well as:
\itemize{
\item \code{graph} :: \code{\link{Graph}}\cr
\code{\link{Graph}} that is being wrapped. This field contains the prototype of the \code{\link{Graph}} that is being trained, but does \emph{not}
contain the model. Use \code{graph_model} to access the trained \code{\link{Graph}} after \verb{$train()}. Read-only.
\item \code{graph_model} :: \code{\link[mlr3:Learner]{Learner}}\cr
\code{\link{Graph}} that is being wrapped. This \code{\link{Graph}} contains a trained state after \verb{$train()}. Read-only.
}
}

\section{Internals}{

\code{\link[=as_graph]{as_graph()}} is called on the \code{graph} argument, so it can technically also be a \code{list} of things, which is
automatically converted to a \code{\link{Graph}} via \code{\link[=gunion]{gunion()}}; however, this will usually not result in a valid \code{\link{Graph}} that can
work as a \code{\link[mlr3:Learner]{Learner}}. \code{graph} can furthermore be a \code{\link[mlr3:Learner]{Learner}}, which is then automatically
wrapped in a \code{\link{Graph}}, which is then again wrapped in a \code{GraphLearner} object; this usually only adds overhead and is not
recommended.
}

\examples{
\dontshow{ if (requireNamespace("rpart")) \{ }
library("mlr3")

graph = po("pca") \%>>\% lrn("classif.rpart")

lr = GraphLearner$new(graph)
lr = as_learner(graph)  # equivalent

lr$train(tsk("iris"))

lr$graph$state  # untrained version!
# The following is therefore NULL:
lr$graph$pipeops$classif.rpart$learner_model$model

# To access the trained model from the PipeOpLearner's Learner, use:
lr$graph_model$pipeops$classif.rpart$learner_model$model

# Feature importance (of principal components):
lr$graph_model$pipeops$classif.rpart$learner_model$importance()
\dontshow{ \} }
}
\seealso{
Other Learners: 
\code{\link{mlr_learners_avg}}
}
\concept{Learners}
