% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purrr_map.R
\name{compat-map}
\alias{compat-map}
\alias{map}
\alias{map_lgl}
\alias{map_int}
\alias{map_dbl}
\alias{map_chr}
\alias{map_dtr}
\alias{map_dtc}
\alias{pmap}
\alias{pmap_lgl}
\alias{pmap_int}
\alias{pmap_dbl}
\alias{pmap_chr}
\alias{pmap_dtr}
\alias{pmap_dtc}
\alias{imap}
\alias{imap_lgl}
\alias{imap_int}
\alias{imap_dbl}
\alias{imap_chr}
\alias{imap_dtr}
\alias{imap_dtc}
\alias{keep}
\alias{discard}
\alias{map_if}
\alias{map_at}
\alias{every}
\alias{some}
\title{Apply Functions in the spirit of 'purrr'}
\usage{
map(.x, .f, ...)

map_lgl(.x, .f, ...)

map_int(.x, .f, ...)

map_dbl(.x, .f, ...)

map_chr(.x, .f, ...)

map_dtr(.x, .f, ..., .fill = FALSE)

map_dtc(.x, .f, ...)

pmap(.x, .f, ...)

pmap_lgl(.x, .f, ...)

pmap_int(.x, .f, ...)

pmap_dbl(.x, .f, ...)

pmap_chr(.x, .f, ...)

pmap_dtr(.x, .f, ..., .fill = FALSE)

pmap_dtc(.x, .f, ...)

imap(.x, .f, ...)

imap_lgl(.x, .f, ...)

imap_int(.x, .f, ...)

imap_dbl(.x, .f, ...)

imap_chr(.x, .f, ...)

imap_dtr(.x, .f, ..., .fill = FALSE)

imap_dtc(.x, .f, ...)

keep(.x, .f, ...)

discard(.x, .p, ...)

map_if(.x, .p, .f, ...)

map_at(.x, .at, .f, ...)

every(.x, .p, ...)

some(.x, .p, ...)
}
\arguments{
\item{.x}{:: (\code{list()} or atomic \code{vector}).}

\item{.f}{:: (\code{function} | \code{character()} | \code{integer()})\cr
Function to apply, or element to extract by name (if \code{.f} is \code{character()}) or position (if \code{.f} is \code{integer()}).}

\item{...}{:: \code{any}\cr
Additional arguments passed down to \code{.f} or \code{.p}.}

\item{.fill}{:: \code{logical(1)}\cr
Passed down to \code{\link[data.table:rbindlist]{data.table::rbindlist()}}.}

\item{.p}{:: (\code{function()} | \code{logical()})\cr
Predicate function.}

\item{.at}{:: (\code{character()} | \code{integer()} | \code{logical()})\cr
Index vector.}
}
\description{
\code{map}-like functions, similar to the ones implemented in \CRANpkg{purrr}:
\itemize{
\item \code{map()} returns the results of \code{.f} applied to \code{.x} as list.
If \code{.f} is not a function, \code{map} will call \code{[[} on all elements of \code{.x} using the value of \code{.f} as index.
\item \code{imap()} applies \code{.f} to each value of \code{.x} (passed as first argument) and its name (passed as second argument).
If \code{.x} does not have names, a sequence along \code{.x} is passed as second argument instead.
\item \code{pmap()} expects \code{.x} to be a list of vectors of equal length, and then applies \code{.f} to the first element of each vector of \code{.x}, then the second element of \code{.x}, and so on.
\item \code{map_if()} applies \code{.f} to each element of \code{.x} where the predicate \code{.p} evaluates to \code{TRUE}.
\item \code{map_at()} applies \code{.f} to each element of \code{.x} referenced by \code{.at}. All other elements remain unchanged.
\item \code{keep()} keeps those elements of \code{.x} where predicate \code{.p} evaluates to \code{TRUE}.
\item \code{discard()} discards those elements of \code{.x} where predicate \code{.p} evaluates to \code{TRUE}.
\item \code{every()} is \code{TRUE} if predicate \code{.p} evaluates to \code{TRUE} for each \code{.x}.
\item \code{some()} is \code{TRUE} if predicate \code{.p} evaluates to \code{TRUE} for at least one \code{.x}.
}

Additionally, the functions \code{map()}, \code{imap()} and \code{pmap} have type-safe variants with the following suffixes:
\itemize{
\item \code{*_lgl()} returns a \code{logical(length(.x))}.
\item \code{*_int()} returns a \code{integer(length(.x))}.
\item \code{*_dbl()} returns a \code{double(length(.x))}.
\item \code{*_chr()} returns a \code{character(length(.x))}.
\item \code{*_dtr()} returns a \code{\link[data.table:data.table]{data.table::data.table()}} where the results of \code{.f} are put together in an \code{\link[base:rbind]{base::rbind()}} fashion.
\item \code{*_dtc()} returns a \code{\link[data.table:data.table]{data.table::data.table()}} where the results of \code{.f} are put together in an \code{\link[base:cbind]{base::cbind()}} fashion.
}
}
