% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_mae.R
\name{mae}
\alias{mae}
\title{Mean Absolute Errors}
\usage{
mae(truth, response, ...)
}
\arguments{
\item{truth}{(\code{numeric()})\cr
True (observed) values.
Must have the same length as \code{response}.}

\item{response}{(\code{numeric()})\cr
Predicted response values.
Must have the same length as \code{truth}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Regression measure defined as \deqn{
  \frac{1}{n} \sum_{i=1}^n \left| t_i - r_i \right|.
}{
  mean(abs(t - r)).
}
}
\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
truth = 1:10
response = truth + rnorm(10)
mae(truth, response)
}
\seealso{
Other Regression Measures: 
\code{\link{bias}()},
\code{\link{ktau}()},
\code{\link{mape}()},
\code{\link{maxae}()},
\code{\link{maxse}()},
\code{\link{medae}()},
\code{\link{medse}()},
\code{\link{mse}()},
\code{\link{msle}()},
\code{\link{pbias}()},
\code{\link{rae}()},
\code{\link{rmse}()},
\code{\link{rmsle}()},
\code{\link{rrse}()},
\code{\link{rse}()},
\code{\link{rsq}()},
\code{\link{sae}()},
\code{\link{smape}()},
\code{\link{srho}()},
\code{\link{sse}()}
}
\concept{Regression Measures}
\concept{regression_measure}
