#' @importFrom utils bibentry
bibentries = c( # nolint start

  brodersen_2010     = bibentry("inproceedings",
    title            = "The Balanced Accuracy and Its Posterior Distribution",
    author           = "Kay Henning Brodersen and Cheng Soon Ong and Klaas Enno Stephan and Joachim M. Buhmann",
    year             = "2010",
    booktitle        = "2010 20th International Conference on Pattern Recognition",
    publisher        = "IEEE",
    doi              = "10.1109/icpr.2010.764"
  ),
  davis_2006         = bibentry("inproceedings",
    title            = "The relationship between precision-recall and ROC curves",
    author           = "Jesse Davis and Mark Goadrich",
    year             = "2006",
    booktitle        = "Proceedings of the 23rd International Conference on Machine Learning",
    publisher        = "ACM",
    isbn             = "9781595933836"
  ),
  de_myttenaere_2016 = bibentry("article",
    title            = "Mean Absolute Percentage Error for regression models",
    author           = "de Myttenaere, Arnaud and Golden, Boris and Le Grand, B\u00e9n\u00e9dicte and Rossi, Fabrice",
    year             = "2016",
    journal          = "Neurocomputing",
    publisher        = "Elsevier BV",
    volume           = "192",
    pages            = "38-48",
    doi              = "10.1016/j.neucom.2015.12.114",
    issn             = "0925-2312"
  ),
  guyon_2015         = bibentry("inproceedings",
    title            = "Design of the 2015 {ChaLearn} {AutoML} challenge",
    author           = "Isabelle Guyon and Kristin Bennett and Gavin Cawley and Hugo Jair Escalante and Sergio Escalera and  Tin Kam Ho and Nuria Macia and Bisakha Ray and Mehreen Saeed and Alexander Statnikov and Evelyne Viegas",
    year             = "2015",
    booktitle        = "2015 International Joint Conference on Neural Networks ({IJCNN})",
    publisher        = "IEEE",
    doi              = "10.1109/ijcnn.2015.7280767"
  ),
  matthews_1975      = bibentry("article",
    title            = "Comparison of the predicted and observed secondary structure of T4 phage lysozyme",
    author           = "Brian W. Matthews",
    year             = "1975",
    journal          = "Biochimica et Biophysica Acta ({BBA}) - Protein Structure",
    publisher        = "Elsevier {BV}",
    volume           = "405",
    number           = "2",
    pages            = "442--451",
    doi              = "10.1016/0005-2795(75)90109-9"
  ),
  rijsbergen_1979    = bibentry("book",
    title            = "Information Retrieval",
    author           = "Rijsbergen, C. J. Van",
    year             = "1979",
    publisher        = "Butterworth-Heinemann",
    address          = "Newton, MA, USA",
    isbn             = "408709294",
    edition          = "2nd"
  ),
  rosset_2006        = bibentry("article",
    title            = "Ranking-based evaluation of regression models",
    author           = "Saharon Rosset and Claudia Perlich and Bianca Zadrozny",
    year             = "2006",
    journal          = "Knowledge and Information Systems",
    publisher        = "Springer Science and Business Media {LLC}",
    volume           = "12",
    number           = "3",
    pages            = "331--353",
    doi              = "10.1007/s10115-006-0037-3"
  ),
  sasaki_2007        = bibentry("article",
    title            = "The truth of the F-measure",
    author           = "Sasaki, Yutaka and others",
    year             = "2007",
    journal          = "Teach Tutor mater",
    volume           = "1",
    number           = "5",
    pages            = "1--5",
    url              = "https://www.cs.odu.edu/~mukka/cs795sum10dm/Lecturenotes/Day3/F-measure-YS-26Oct07.pdf"
  ),
  youden_1950        = bibentry("article",
    title            = "Index for rating diagnostic tests",
    author           = "W. J. Youden",
    year             = "1950",
    journal          = "Cancer",
    publisher        = "Wiley",
    volume           = "3",
    number           = "1",
    pages            = "32--35",
    doi              = "10.1002/1097-0142(1950)3:1<32::aid-cncr2820030106>3.0.co;2-3"
  ),
  brier_1950         = bibentry("article",
    doi              = "10.1175/1520-0493(1950)078<0001:vofeit>2.0.co;2",
    year             = "1950",
    month            = "jan",
    publisher        = "American Meteorological Society",
    volume           = "78",
    number           = "1",
    pages            = "1--3",
    author           = "Glenn W. Brier",
    title            = "Verification of forecasts expressed in terms of probability",
    journal          = "Monthly Weather Review"
  ),
  ferri_2009         = bibentry("article",
    doi              = "10.1016/j.patrec.2008.08.010",
    year             = "2009",
    month            = "jan",
    publisher        = "Elsevier",
    volume           = "30",
    number           = "1",
    pages            = "27--38",
    author           = "Ferri, C\u00e9sar and Hern\u00e1ndez-Orallo, Jos\u00e9 and Modroiu, R",
    title            = "An experimental comparison of performance measures for classification",
    journal          = "Pattern Recognition Letters"
  ),
  hand_2001          = bibentry("article",
    title            = "A simple generalisation of the area under the ROC curve for multiple class classification problems",
    author           = "Hand, David J and Till, Robert J",
    journal          = "Machine learning",
    volume           = "45",
    number           = "2",
    pages            = "171--186",
    year             = "2001",
    publisher        = "Springer"
  ),
  fawcett_2001       = bibentry("inproceedings",
    title            = "Using rule sets to maximize ROC performance",
    author           = "Fawcett, Tom",
    booktitle        = "Proceedings 2001 IEEE international conference on data mining",
    pages            = "131--138",
    year             = "2001",
    organization     = "IEEE"
  )
) # nolint end
