% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrKM.R
\name{mlr_learners_regr.km}
\alias{mlr_learners_regr.km}
\alias{LearnerRegrKM}
\title{Kriging Regression Learner}
\description{
Kriging regression.
Calls \code{\link[DiceKriging:km]{DiceKriging::km()}} from package \CRANpkg{DiceKriging}.
\itemize{
\item The predict type hyperparameter "type" defaults to "sk" (simple kriging).
\item The additional hyperparameter \code{nugget.stability} is used to overwrite the
hyperparameter \code{nugget} with \code{nugget.stability * var(y)} before training to
improve the numerical stability. We recommend a value of \code{1e-8}.
\item The additional hyperparameter \code{jitter} can be set to add
\verb{N(0, [jitter])}-distributed noise to the data before prediction to avoid
perfect interpolation. We recommend a value of \code{1e-12}.
}
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:\preformatted{mlr_learners$get("regr.km")
lrn("regr.km")
}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Predict Types: \dQuote{response}, \dQuote{se}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{DiceKriging}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Range \tab Levels \cr
   bias.correct \tab logical \tab FALSE \tab - \tab TRUE, FALSE \cr
   checkNames \tab logical \tab TRUE \tab - \tab TRUE, FALSE \cr
   coef.cov \tab list \tab NULL \tab - \tab - \cr
   coef.trend \tab list \tab NULL \tab - \tab - \cr
   coef.var \tab list \tab NULL \tab - \tab - \cr
   control \tab list \tab NULL \tab - \tab - \cr
   cov.compute \tab logical \tab TRUE \tab - \tab TRUE, FALSE \cr
   covtype \tab character \tab matern5_2 \tab - \tab gauss, matern5_2, matern3_2, exp, powexp \cr
   estim.method \tab character \tab MLE \tab - \tab MLE, LOO \cr
   gr \tab logical \tab TRUE \tab - \tab TRUE, FALSE \cr
   iso \tab logical \tab FALSE \tab - \tab TRUE, FALSE \cr
   jitter \tab numeric \tab 0 \tab \eqn{[0, \infty)}{[0, Inf)} \tab - \cr
   kernel \tab list \tab NULL \tab - \tab - \cr
   knots \tab list \tab NULL \tab - \tab - \cr
   light.return \tab logical \tab FALSE \tab - \tab TRUE, FALSE \cr
   lower \tab list \tab NULL \tab - \tab - \cr
   multistart \tab integer \tab 1 \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \tab - \cr
   noise.var \tab list \tab NULL \tab - \tab - \cr
   nugget \tab numeric \tab - \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \tab - \cr
   nugget.estim \tab logical \tab FALSE \tab - \tab TRUE, FALSE \cr
   nugget.stability \tab numeric \tab 0 \tab \eqn{[0, \infty)}{[0, Inf)} \tab - \cr
   optim.method \tab character \tab BFGS \tab - \tab BFGS, gen \cr
   parinit \tab list \tab NULL \tab - \tab - \cr
   penalty \tab list \tab NULL \tab - \tab - \cr
   scaling \tab logical \tab FALSE \tab - \tab TRUE, FALSE \cr
   se.compute \tab logical \tab TRUE \tab - \tab TRUE, FALSE \cr
   type \tab character \tab SK \tab - \tab SK, UK \cr
   upper \tab list \tab NULL \tab - \tab - \cr
}
}

\examples{
if (requireNamespace("DiceKriging", quietly = TRUE)) {
  learner = mlr3::lrn("regr.km")
  print(learner)

  # available parameters:
learner$param_set$ids()
}
}
\references{
Roustant O, Ginsbourger D, Deville Y (2012).
\dQuote{DiceKriging, DiceOptim: Two R Packages for the Analysis of Computer Experiments by Kriging-Based Metamodeling and Optimization.}
\emph{Journal of Statistical Software}, \bold{51}(1), 1--55.
\doi{10.18637/jss.v051.i01}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.ranger}},
\code{\link{mlr_learners_regr.svm}},
\code{\link{mlr_learners_regr.xgboost}},
\code{\link{mlr_learners_surv.cv_glmnet}},
\code{\link{mlr_learners_surv.glmnet}},
\code{\link{mlr_learners_surv.ranger}},
\code{\link{mlr_learners_surv.xgboost}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrKM}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LearnerRegrKM$new()}}
\item \href{#method-clone}{\code{LearnerRegrKM$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner">}\href{../../mlr3/html/Learner.html#method-base_learner}{\code{mlr3::Learner$base_learner()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrKM$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrKM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
